---
name: r.massmov
description: Estimates run-out and deposition of landslide phenomena over a complex topography.
keywords: [ raster, landslide, model, parallel ]
---

# r.massmov

Estimates run-out and deposition of landslide phenomena over a complex topography.

=== "Command line"

    **r.massmov**
    [**-im**]
    **elev**=*string*
    **h_ini**=*string*
    **fluiddist**=*string*
    **rheology**=*string*
    [**rho**=*float*]
    [**ystress**=*float*]
    [**visco**=*float*]
    [**chezy**=*float*]
    [**bfrict**=*float*]
    **ifrict**=*float*
    **fluid**=*float*
    **timesteps**=*integer*
    [**deltatime**=*integer*]
    [**stop_thres**=*float*]
    [**step_thres**=*integer*]
    [**threads**=*integer*]
    [**h**=*string*]
    [**h_max**=*string*]
    [**v**=*string*]
    [**v_max**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.massmov elev=string h_ini=string fluiddist=string rheology=frictional ifrict=0.0 fluid=0.0 timesteps=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.massmov***",
        **elev**,
        **h_ini**,
        **fluiddist**,
        **rheology**,
        **rho**=*None*,
        **ystress**=*None*,
        **visco**=*None*,
        **chezy**=*None*,
        **bfrict**=*None*,
        **ifrict**,
        **fluid**,
        **timesteps**,
        **deltatime**=*None*,
        **stop_thres**=*None*,
        **step_thres**=*None*,
        **threads**=*None*,
        **h**=*None*,
        **h_max**=*None*,
        **v**=*None*,
        **v_max**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.massmov", elev="string", h_ini="string", fluiddist="string", rheology="frictional", ifrict=0.0, fluid=0.0, timesteps=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_massmov*(**elev**,
        **h_ini**,
        **fluiddist**,
        **rheology**,
        **rho**=*None*,
        **ystress**=*None*,
        **visco**=*None*,
        **chezy**=*None*,
        **bfrict**=*None*,
        **ifrict**,
        **fluid**,
        **timesteps**,
        **deltatime**=*None*,
        **stop_thres**=*None*,
        **step_thres**=*None*,
        **threads**=*None*,
        **h**=*None*,
        **h_max**=*None*,
        **v**=*None*,
        **v_max**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_massmov(elev="string", h_ini="string", fluiddist="string", rheology="frictional", ifrict=0.0, fluid=0.0, timesteps=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elev**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map  
    **h_ini**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of landslide initial body thickness raster map  
    **fluiddist**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of distance from the landlide toe raster map  
    **rheology**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of rheological law  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *frictional, Voellmy, viscoplastic*  
    **rho**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Density of the flow [Kg/m3]. Required only for viscous rheologies.  
    **ystress**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Apparent yield stress [Pa]. Used only for viscous rheologies (optional).  
    **visco**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dynamic viscosity [Pa\*s]. Required only for viscous rheologies  
    **chezy**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Chezy roughness coefficient [m/s2]. Required only for Voellmy rheology  
    **bfrict**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of basal friction [deg]  
    **ifrict**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of internal friction [deg]  
    **fluid**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Upward velocity of transition from solid to fluid of the landsliding mass [m/s]  
    **timesteps**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of time steps of the simulation [s]  
    **deltatime**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reporting time frequency [s]  
    **stop_thres**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pearson value threshold for simulation stop [-]  
    **step_thres**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of time steps for evaluating stop_thres value [-]  
    **threads**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    **h**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for flow thickness output raster maps  
    **h_max**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for maximum flow thickness output raster maps  
    **v**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for flow velocity output raster maps  
    **v_max**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for maximum flow velocity output raster maps  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print input data  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print memory usage requirements  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elev** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **h_ini** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of landslide initial body thickness raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **fluiddist** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of distance from the landlide toe raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **rheology** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of rheological law  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *frictional, Voellmy, viscoplastic*  
    **rho** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Density of the flow [Kg/m3]. Required only for viscous rheologies.  
    **ystress** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Apparent yield stress [Pa]. Used only for viscous rheologies (optional).  
    **visco** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dynamic viscosity [Pa\*s]. Required only for viscous rheologies  
    **chezy** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Chezy roughness coefficient [m/s2]. Required only for Voellmy rheology  
    **bfrict** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of basal friction [deg]  
    **ifrict** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of internal friction [deg]  
    **fluid** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Upward velocity of transition from solid to fluid of the landsliding mass [m/s]  
    **timesteps** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of time steps of the simulation [s]  
    **deltatime** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reporting time frequency [s]  
    **stop_thres** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pearson value threshold for simulation stop [-]  
    **step_thres** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of time steps for evaluating stop_thres value [-]  
    **threads** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    **h** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for flow thickness output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **h_max** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for maximum flow thickness output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **v** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for flow velocity output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **v_max** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for maximum flow velocity output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print input data  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print memory usage requirements  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elev** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **h_ini** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of landslide initial body thickness raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **fluiddist** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of distance from the landlide toe raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **rheology** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of rheological law  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *frictional, Voellmy, viscoplastic*  
    **rho** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Density of the flow [Kg/m3]. Required only for viscous rheologies.  
    **ystress** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Apparent yield stress [Pa]. Used only for viscous rheologies (optional).  
    **visco** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dynamic viscosity [Pa\*s]. Required only for viscous rheologies  
    **chezy** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Chezy roughness coefficient [m/s2]. Required only for Voellmy rheology  
    **bfrict** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of basal friction [deg]  
    **ifrict** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of internal friction [deg]  
    **fluid** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Upward velocity of transition from solid to fluid of the landsliding mass [m/s]  
    **timesteps** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of time steps of the simulation [s]  
    **deltatime** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reporting time frequency [s]  
    **stop_thres** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pearson value threshold for simulation stop [-]  
    **step_thres** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of time steps for evaluating stop_thres value [-]  
    **threads** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    **h** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for flow thickness output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **h_max** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for maximum flow thickness output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **v** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for flow velocity output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **v_max** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for maximum flow velocity output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print input data  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print memory usage requirements  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

r.massmov is a numerical model that allows users to simulate the
expansion (runout) and deposition of mass movements over a complex
topography by approximating the heterogeneous sliding mass to a
homogeneous one-phase fluid (following the approach proposed by Savage
and Hutter (1989) and Iverson and Denlinger (2001)). The model describes
the mass movements as a two-dimensional flux taking advantage of the
shallow water equations. This formula is derived from the general
Navier-Stokes equations under the hypothesis that the vertical
components of velocity and pressure are negligible with respect to the
horizontal components, and that the vertical pressure profile can be
considered as almost hydrostatic (Kinnmark 1985).

The required inputs can be classified in three categories based on the
information type:

- raster maps of the topography, in particular the sliding surface
    topography *elev* (digital terrain model without the sliding body),
    the initial sliding mass thickness *h\_ini* and the 'distance map'
    *fluiddist*, representing the cells distance from the collapsing
    body lower limit;
- numerical parameters for the characterization of the mass material,
    density *rho* \[kg/m3\], apparent yield stress *ystress* \[Pa\],
    Chezy roughness coefficient *chezy* \[m/s2\], dynamic viscosity
    *visco* \[Pa\*s\], basal friction angle *bfrict* \[deg\], internal
    friction angle of the sliding mass during the expansion *ifrict*
    \[deg\] and the fluid rate *fluid* \[m/s\].This last parameter
    provides information on the transaction velocity of the sliding mass
    when passes from a solid state to a fluid state; together with the
    'distance map' it allows to define the amount of mass mobilized as a
    function of time. It is worth noting that depending on the selected
    rheological law different sets of parameters are mandatory;
- control parameters to stop the simulation (like maximum time step
    number *timesteps* and/or automatic stopping criterion parameters
    *stop\_thres* and *step\_thres*) and to set the number of processors
    for parallel computing (*threads*). If the parallel computing is
    activated, and unless of different settings, the program runs using
    all the available processors.

The model outputs a series of flux velocity map (*v*) and deposit depth
raster map (*h*) at different time step according to the set deltatime
parameter; additionally the module outputs two raster maps representing
the maximum thickness (*h\_max*) and velocity (*v\_max*) registered
during the simulation.

## NOTES

The generation of the model input maps, in case the simulation refer to
en existing collapse and pre and post event DTM is available, can be
performed taking advantage of the GRASS modules; in particular:

- the sliding surface can be calculated by subtracting the collapsing
    body from the pre-event DTM (r.mapcalc)
- the collapsing body thickness can evaluated by considering the
    negative differences between the post and pre-event DTM multiplied
    for the cosine of the slope (r.mapcalc and r.slope.aspect)
- the distance map from the landslide toe can be obtained by applying
    the r.grow.distance module to the rasterized limits of the landslide

## DIAGNOSTICS

The module has been tested in several cases (see references), but up to
now most of the simulations was done using a Voellmy rheology thus other
rheology laws should be better investigated.

## REFERENCES

Begueria S, Van Asch T W J, Malet J P and Grondahl S 2009 A GIS based
numerical model for simulating the kinematics of mud and debris flows
over complex terrain. Nat Hazards Earth Syst Sci, 9, 1897-1909.

Iverson R M and Denlinger R P 2001 Flow of variably fluidized granular
masses across threedimensional terrain: 1, Coulomb mixture theory.
Journal of Geophysical Research 106:537-52

Kinnmark I P E 1985 The shallow water equations: Formulation, analysis
and application. In Brebia C A and Orszag S A (eds) Lecture Notes in
Engineering 15. Berlin, Springer-Verlag:1-187

Molinari M, Cannata M, Begueria S and Ambrosi C 2012 GIS-based
Calibration of MassMov2D. Transactions in GIS, 2012, 16(2):215-231

Savage S B and Hutter K 1989 The motion of a finite mass of granular
material down a rough incline. Journal of Fluid Mechanics 199:177-215

## SEE ALSO

[r.grow.distance](https://grass.osgeo.org/grass-stable/manuals/r.grow.distance.html)  
[r.slope.aspect](https://grass.osgeo.org/grass-stable/manuals/r.slope.aspect.html)  
[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html)  

## AUTHORS

*Original version of program:*  
Santiago Begueria

*The current version of the program (ported to GRASS7.0)*:  
Monia Molinari, Massimiliano Cannata, Santiago Begueria.

## SOURCE CODE

Available at: [r.massmov source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.massmov)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.massmov))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
