---
name: r.maxent.setup.py
description: Helper module to install Maxent to the addon directory
keywords: [ modeling, Maxent ]
---

# r.maxent.setup.py

Helper module to install Maxent to the addon directory

=== "Command line"

    **r.maxent.setup.py**
    [**-ju**]
    [**maxent**=*name*]
    [**java**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.maxent.setup.py maxent=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.maxent.setup.py***",
        **maxent**=*None*,
        **java**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.maxent.setup.py", maxent="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_maxent_setup_py*(**maxent**=*None*,
        **java**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_maxent_setup_py(maxent="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **maxent**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location Maxent jar file  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the path to the Maxent executable file (maxent.jar)  
    **java**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location Jave executable  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the path to the Java executable file.  
    **-j**  
    &nbsp;&nbsp;&nbsp;&nbsp;Check if Java can be found on the system  
    &nbsp;&nbsp;&nbsp;&nbsp;Check if Java can be found from the GRASS GIS command line.  
    **-u**  
    &nbsp;&nbsp;&nbsp;&nbsp;Overwrites maxent.jar in addon directory  
    &nbsp;&nbsp;&nbsp;&nbsp;If the Maxent executable already exists in the addon directory, it will be overwritten.  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **maxent** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location Maxent jar file  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the path to the Maxent executable file (maxent.jar)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **java** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location Jave executable  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the path to the Java executable file.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *j*, *u*  
    &nbsp;&nbsp;&nbsp;&nbsp;**j**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Check if Java can be found on the system  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Check if Java can be found from the GRASS GIS command line.  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Overwrites maxent.jar in addon directory  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;If the Maxent executable already exists in the addon directory, it will be overwritten.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **maxent** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location Maxent jar file  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the path to the Maxent executable file (maxent.jar)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **java** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location Jave executable  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the path to the Java executable file.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *j*, *u*  
    &nbsp;&nbsp;&nbsp;&nbsp;**j**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Check if Java can be found on the system  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Check if Java can be found from the GRASS GIS command line.  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Overwrites maxent.jar in addon directory  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;If the Maxent executable already exists in the addon directory, it will be overwritten.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r.maxent.setup* addon provides a helper function to install Maxent
and ensures that GRASS GIS can locate the Java executable, a
prerequisite for running Maxent.

### Maxent

The *r.maxent.train* and *r.maxent.predict* modules require the Maxent
software, which can be downloaded from the [Maxent
website](https://biodiversityinformatics.amnh.org/open_source/maxent).
The *r.maxent.setup* installs this to the GRASS GIS addon directory. If
you want to update the Maxent.jar file, use the **-u** flag.

### Java

Maxent requires Java to be installed, and it should be accessible from
the GRASS GIS environment. You can check this by running the
*r.maxent.setup* with the **-j** flag.

On Windows, even if JAVA is installed and on the PATH, GRASS GIS may
still not be able to find it. The reason is that OSGeo4W environment
used by GRASS GIS on Windows has its own shell environment, which may
not automatically inherit the system-wide PATH or environment variables
from Windows. As a result, even if Java is correctly installed and
accessible from a regular Command Prompt or PowerShell, it might not be
visible to GRASS GIS within the OSGeo4W shell.

To enable GRASS GIS to find the path to the Java executable, you can set
the path to the executable using the **java** parameter. The path will
be written to a text file in the GRASS GIS addon directory, which can be
used by the *r.maxent.train* and *r.maxent.predict* modules.

An arguably better but more involved way is to add the Java directory to
the OSGeo4W PATH. See the NOTES for a short 'how to'.

## NOTES

Instead of using this addon to set the path to the java executable, you
can add the Java directory to the OSGeo4W PATH temporarily. Open the
Open the OSGeo4W shell and run the following:

```sh
set PATH=C:\Program Files\Java\jdk-XX.X.X\bin;%PATH%
```

Replace C:\\Program Files\\Java\\jdk-XX.X.X\\bin with your Java
installation path. To make this change persistent, you need to edit the
*osgeo4w.bat* file. This file can be found in the OSGeo4W installation
folder. Locate the file, and find the line that starts with *set PATH=*.

At the end of that line, add a semi-colun and the path to the Java
installation path. For example:

```sh
set PATH=%PATH%;C:\Program Files\Java\jdk-XX.X.X\bin;
```

Replace C:\\Program Files\\Java\\jdk-XX.X.X\\bin with your Java
installation path. Save the file and restart the OSGeo4W shell. Note
that you may need administrator rightrs to edit the osgeo4w.bat file.

## SEE ALSO

- [v.maxent.train](v.maxent.train.md)
- [v.maxent.predict](v.maxent.predict.md)

## AUTHOR

[Paulo van Breugel](https://ecodiv.earth), [HAS green
academy](https://has.nl), [Innovative Biomonitoring research
group](https://www.has.nl/en/research/professorships/innovative-bio-monitoring-professorship/),
[Climate-robust Landscapes research
group](https://www.has.nl/en/research/professorships/climate-robust-landscapes-professorship/)

## SOURCE CODE

Available at: [r.maxent.setup source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.maxent.setup)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.maxent.setup))  
Latest change: Sunday Aug 03 17:46:30 2025 in commit [e1d16ff](https://github.com/OSGeo/grass-addons/commit/e1d16ff9b3f1d7b4e71a69c15eea4caf01693a06)
