---
name: r.mcda.ahp.py
description: Generates a raster map classified with analytic hierarchy process (AHP).
keywords: [ raster, Analytic Hierarchy Process (AHP), Multi Criteria Decision Analysis (MCDA) ]
---

# r.mcda.ahp.py

Generates a raster map classified with analytic hierarchy process (AHP).

=== "Command line"

    **r.mcda.ahp.py**
    [**-k**]
    **criteria**=*name* [,*name*,...]
    **pairwise**=*string*
    **output**=*string*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.mcda.ahp.py criteria=name pairwise=string output=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.mcda.ahp.py***",
        **criteria**,
        **pairwise**,
        **output**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.mcda.ahp.py", criteria="name", pairwise="string", output="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_mcda_ahp_py*(**criteria**,
        **pairwise**,
        **output**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_mcda_ahp_py(criteria="name", pairwise="string", output="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **criteria**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of criteria raster maps  
    **pairwise**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Pairwise comparison matrix  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;output classified raster map  
    **-k**  
    &nbsp;&nbsp;&nbsp;&nbsp;build a void pairwise comparison matrix and exit (no yet implemented)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **criteria** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of criteria raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **pairwise** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pairwise comparison matrix  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, input  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;output classified raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *k*  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;build a void pairwise comparison matrix and exit (no yet implemented)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **criteria** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of criteria raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **pairwise** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pairwise comparison matrix  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, input  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;output classified raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *k*  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;build a void pairwise comparison matrix and exit (no yet implemented)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r.mcda.ahp* Generate a raster map classified with analytic
hierarchy process (AHP) \[Saaty, 1977 and Saaty & Vargas, 1991\]

## NOTES

It is mandatory to build a pairwise comparation table with the same
order of input of criteria maps in the criteria field.

Example: r.mcda.ahp criteria=reclass\_slope,reclass\_sand,reclass\_elev
pairwise=pairwise output=outputMap

The file "pairwise" has to have a structure like this:

\#start file

1.0, 0.2, 3.0

5.0, 1.0, 5.0

0.3, 0.2, 1.0

\#comment: order: reclass\_slope,reclass\_sand,reclass\_

\#end file

The first row and first column are related to the first criteria
(reclass\_slope in our case); the second row and second column are
related to the second criteria (reclass\_sand in our case) and the third
row and third column are related to the third criteria ( reclass\_elev
in our cas), and so on.

In the work directory should be generated a log.txt file were you can
find additional information like: eigenvectors, eigenvalues, weights

## TODO

## SEE ALSO

*[r.roughset](r.roughset.md), [r.mcda.regime](r.mcda.regime.md),
[r.mcda.fuzzy](r.mcda.fuzzy.md) [r.mcda.electre](r.mcda.electre.md),
[r.mcda.roughset](r.mcda.roughset.md) [r.in.drsa](r.in.drsa.md)
[r.to.drsa](r.to.drsa.md)*

## AUTHORS

Antonio Boggia - Gianluca Massei  
Department of Economics and Appraisal - University of Perugia - Italy

## SOURCE CODE

Available at: [r.mcda.ahp source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.mcda.ahp)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.mcda.ahp))  
Latest change: Thursday Feb 20 20:36:19 2025 in commit [158e314](https://github.com/OSGeo/grass-addons/commit/158e314c788f983e3a448ec1b1ba3f226b5ca3e9)
