---
name: r.neighborhoodmatrix
description: Calculates geometry parameters for raster objects.
keywords: [ raster, statistics, reclass, clumps ]
---

# r.neighborhoodmatrix

Calculates geometry parameters for raster objects.

=== "Command line"

    **r.neighborhoodmatrix**
    [**-dlc**]
    **input**=*name*
    [**output**=*name*]
    [**separator**=*character*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.neighborhoodmatrix input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.neighborhoodmatrix***",
        **input**,
        **output**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.neighborhoodmatrix", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_neighborhoodmatrix*(**input**,
        **output**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_neighborhoodmatrix(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster for which to calculate the neighboorhood matrix  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Also take into account diagonal neighbors  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Also output length of common border (in pixels)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Include column names in output (meaning will be inversed soon)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster for which to calculate the neighboorhood matrix  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *l*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also take into account diagonal neighbors  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also output length of common border (in pixels)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include column names in output (meaning will be inversed soon)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster for which to calculate the neighboorhood matrix  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *l*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also take into account diagonal neighbors  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also output length of common border (in pixels)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include column names in output (meaning will be inversed soon)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.neighborhoodmatrix* identifies all adjacency relations between
objects (aka segments or clumps identified by identical integer cell
values of adjacent pixels) in a raster map and exports these as a 2xn
matrix where n is the number of neighborhood relations with each
relation listed in both directions (i.e. if a is neighbor of b, the list
will contain a,b and b,a). If a path to an output file is specified, the
matrix will be written to that file, otherwise it will be sent to
standard output.

Neighborhood relations are determined pixel by pixel, and by default
only pixels that share a common pixel boundary are considered neighbors.
When the *-d* flag is set pixels sharing a common corner (i.e. diagonal
neighbors) are also taken into account.

When the *-l* flag is set, the module additionally indicates the length
of the common border between two neighbors in number of pixels. As this
length is not clearly defined for diagonal neighbors, the *-l* flag
cannot be used in combination with the *-d* flag.

The *-c* flag currently adds column headers. Please note that **this
flag's meaning will be inversed when GRASS 8 comes out** in order to
harmonize its behaviour with that in other modules.

## NOTES

As neighborhood length is measured in pixels, this length is not in
proportion to length in map units if the location is a lat-long
location, or if the resolution is not the same in East-West and in
North-South direction (rectangular pixels).

The module respects the region settings, so if the raster map is outside
the current computational region, the resulting list of neighbors will
be empty.

## TODO

- Add flag to only output half matrix with each relation only shown
    once.
- Measure neighbordhood length in map units, not only pixels

## EXAMPLE

Start by making sure the input map is of type CELL:

```sh
r.mapcalc "bc_int = int(boundary_county_500m)"
```

Send the neighborhood matrix of the counties in the boundary\_county map
of the North Carolina dataset to standard output:

```sh
r.neighborhoodmatrix in=bc_int sep=comma
```

Idem, but also calculating neighborhood length, sending the output to a
file:

```sh
r.neighborhoodmatrix -l n=bc_int sep=comma output=county_neighbors.csv
```

## SEE ALSO

*[v.neighborhoodmatrix](v.neighborhoodmatrix.md)*

## AUTHORS

Original Python-Version: Moritz Lennert  
C-Version: Markus Metz

## SOURCE CODE

Available at: [r.neighborhoodmatrix source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.neighborhoodmatrix)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.neighborhoodmatrix))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
