---
name: r.niche.similarity.py
description: Computes niche overlap or similarity
keywords: [ raster, niche modelling ]
---

# r.niche.similarity.py

Computes niche overlap or similarity

=== "Command line"

    **r.niche.similarity.py**
    [**-idcm**]
    **maps**=*name* [,*name*,...]
    [**output**=*name*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.niche.similarity.py maps=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.niche.similarity.py***",
        **maps**,
        **output**=*None*,
        **nprocs**=*0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.niche.similarity.py", maps="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_niche_similarity_py*(**maps**,
        **output**=*None*,
        **nprocs**=*0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_niche_similarity_py(maps="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **maps**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input maps  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output text file  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;I niche similarity  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;D niche similarity  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Correlation  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;remove NA cells  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **maps** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output text file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *d*, *c*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;I niche similarity  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;D niche similarity  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Correlation  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;remove NA cells  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **maps** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output text file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *d*, *c*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;I niche similarity  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;D niche similarity  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Correlation  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;remove NA cells  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module *r.niche.similarity* computes two metrics to quantify niche similarity or
overlap between all pairs of input raster layers.

One is the niche equivalency or similarity for two species following Warren et
al. (2008) based on Schoeners D (Schoener, 1968). This metric ranges from 0 to
1, representing respectively no overlap and an identical distribution.

The other is the niche overlap metric which indicates the niche overlap from
predictions of species distributions with the I similarity statistic of Warren
et al. (2009), which is based on Hellinger Distances (van der Vaart, 1998). The
statistic ranges from 0 (no overlap) to 1 (the distributions are identical).

By default the results are written to screen, but they can also be written to a
text file with two columns for the names of each pair of rasters, a third column
for the type of statistic (D or I) and a fourth column for the D or I statistic.

## Notes

This implementation is especially suitable if you are working with very large
data sets. Results were checked against the nicheOverlap function in the dismo
package for R.

If any of the input maps include NODATA cells, these should normally not be
included. To ensure this, the **-m** flag can be set to remove them. This mimics
the default behaviour of the
[nicheOverlap](https://search.r-project.org/CRAN/refmans/dismo/html/nicheOverlap.html)
function in the R dismo package. Depending on what the NODATA represents, an
alternative approcah is to replace the NODATA with 0 values before running
*r.niche.overlap*.

![Illustration of how nodata is handled when the -m flag is
set](r_niche_similarity.png)

*Figure: with the -m flag set, areas with NODATA in any of the input maps are
ignored.*

## EXAMPLE

Create two random rasters

```sh
# Set region
g.region rows=18 cols=36 w=10 s=10 res=0.1

# Create rasters r1 and r2
r.mapcalc 'r1 = rand(0.0,1.0)' seed=0
r.mapcalc 'r1 = rand(0.0,1.0)' seed=1
```

Compute the I and D

```sh
# Create rasters r1 and r2
r.niche.similarity -i -d maps=r1,r2
```

## REFERENCES

- Warren, D. L., Glor, R. E., & Turelli, M. 2008. Environmental Niche
  Equivalency Versus Conservatism: Quantitative Approaches to Niche Evolution.
  Evolution 62(11): 2868-2883
- Warren, D. L., R. E. Glor, and M. Turelli. 2010. ENMTools: a toolbox for
  comparative studies of environmental niche models. Ecography 33:607-611.
- Robert J. Hijmans, Steven Phillips, John Leathwick and Jane Elith (2013).
  Dismo: Species distribution modeling. R package version 0.8-5.
  <http://CRAN.R-project.org/package=dismo>
- Christoph Heibl and Clement Calenge (2012). phyloclim: Integrating
  Phylogenetics and Climatic Niche Modeling. R package version 0.9-0.
  <http://CRAN.R-project.org/package=phyloclim>

## AUTHOR

Paulo van Breugel, [Ecodiv.earth](https://ecodiv.earth), [HAS green
academy](https://has.nl), [Innovative Biomonitoring research
group](https://www.has.nl/en/research/professorships/innovative-bio-monitoring-professorship/),
[Climate-robust Landscapes research
group](https://www.has.nl/en/research/professorships/climate-robust-landscapes-professorship/)

## SOURCE CODE

Available at: [r.niche.similarity source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.niche.similarity)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.niche.similarity))  
Latest change: Saturday Apr 12 06:10:01 2025 in commit [453cfa2](https://github.com/OSGeo/grass-addons/commit/453cfa2fcea17580814cac32bd92ec2fdab8bf3e)
