---
name: r.out.kde.py
description: Exports raster with variable transparency into an image file
keywords: [ raster, kernel density, visualization, transparency, heatmap ]
---

# r.out.kde.py

Exports raster with variable transparency into an image file

=== "Command line"

    **r.out.kde.py**
    **input**=*name*
    **background**=*name*
    **output**=*name*
    [**method**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.out.kde.py input=name background=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.out.kde.py***",
        **input**,
        **background**,
        **output**,
        **method**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.out.kde.py", input="name", background="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_out_kde_py*(**input**,
        **background**,
        **output**,
        **method**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_out_kde_py(input="name", background="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to be rendered with semi-transparency  
    **background**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Background raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Rendered output file  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method to scale transparency  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *linear, logistic*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to be rendered with semi-transparency  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **background** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rendered output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method to scale transparency  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *linear, logistic*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to be rendered with semi-transparency  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **background** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rendered output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method to scale transparency  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *linear, logistic*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.out.kde* creates an image file (e.g., PNG, JPG, or GIF) where the
**input** raster is rendered on top of **background** raster with
varying transparency based on the values of the **input** raster. This
can be used for example for visualization of kernel density estimate
(KDE).

With logistic **method**, values are scaled so that lower values are
more transparent and higher values are more opaque than with linear
scaling.

This module requires [Python Imaging
Library](https://pillow.readthedocs.io/en/stable/) (already required for
GRASS GIS).

## EXAMPLE

In this example, we visualize KDE of schools on top of shaded relief
map.

```sh
g.region raster=elevation
# create background map
r.relief input=elevation output=relief
# compute kernel density estimate
v.kernel input=schools_wake output=schools_density radius=4000 multiplier=1000000
r.colors map=schools_density color=bcyr
r.out.kde input=schools_density background=relief method=logistic output=output.png
```

![image-alt](r_out_kde.png)  

## SEE ALSO

*[d.rast](https://grass.osgeo.org/grass-stable/manuals/d.rast.html),
[v.kernel](https://grass.osgeo.org/grass-stable/manuals/v.kernel.html)*  
  
[Logistic function](https://en.wikipedia.org/wiki/Logistic_function)

## AUTHOR

Anna Petrasova, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.out.kde source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.out.kde)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.out.kde))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
