---
name: r.patch.smooth.py
description: Module for patching rasters with smoothing along edges
keywords: [ raster, patch ]
---

# r.patch.smooth.py

Module for patching rasters with smoothing along edges

=== "Command line"

    **r.patch.smooth.py**
    [**-s**]
    **input_a**=*name*
    **input_b**=*name*
    **output**=*name*
    [**overlap**=*name*]
    [**blend_mask**=*string*]
    [**smooth_dist**=*float*]
    [**transition_angle**=*float*]
    [**parallel_smoothing**=*integer*]
    [**difference_reach**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.patch.smooth.py input_a=name input_b=name output=name smooth_dist=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.patch.smooth.py***",
        **input_a**,
        **input_b**,
        **output**,
        **overlap**=*None*,
        **blend_mask**=*None*,
        **smooth_dist**=*None*,
        **transition_angle**=*None*,
        **parallel_smoothing**=*9*,
        **difference_reach**=*3*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.patch.smooth.py", input_a="name", input_b="name", output="name", smooth_dist=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_patch_smooth_py*(**input_a**,
        **input_b**,
        **output**,
        **overlap**=*None*,
        **blend_mask**=*None*,
        **smooth_dist**=*None*,
        **transition_angle**=*None*,
        **parallel_smoothing**=*9*,
        **difference_reach**=*3*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_patch_smooth_py(input_a="name", input_b="name", output="name", smooth_dist=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input_a**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map A  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **input_b**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map B  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **overlap**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for raster map of spatially variable overlap  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **blend_mask**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster containing edge of raster A which is not to be blended  
    &nbsp;&nbsp;&nbsp;&nbsp;Useful when raster A has common edge with raster B  
    **smooth_dist**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing distance in map units  
    **transition_angle**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of transition for spatially variable overlap  
    &nbsp;&nbsp;&nbsp;&nbsp;Recommended values between 1 and 5 degrees  
    **parallel_smoothing**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of smoothing window for smoothing edges of spatially variable overlap zone  
    &nbsp;&nbsp;&nbsp;&nbsp;Small value results in more rugged shape of the overlap zone, large values result in spatially non-variable overlap zone. Requires odd values.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *3-99*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **difference_reach**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Look for maximum difference between surfaces in surrounding n cells from the edge  
    &nbsp;&nbsp;&nbsp;&nbsp;Recommended values between 3 and 9  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use spatially variable overlap  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input_a** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map A  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **input_b** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map B  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overlap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for raster map of spatially variable overlap  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **blend_mask** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster containing edge of raster A which is not to be blended  
    &nbsp;&nbsp;&nbsp;&nbsp;Useful when raster A has common edge with raster B  
    **smooth_dist** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing distance in map units  
    **transition_angle** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of transition for spatially variable overlap  
    &nbsp;&nbsp;&nbsp;&nbsp;Recommended values between 1 and 5 degrees  
    **parallel_smoothing** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of smoothing window for smoothing edges of spatially variable overlap zone  
    &nbsp;&nbsp;&nbsp;&nbsp;Small value results in more rugged shape of the overlap zone, large values result in spatially non-variable overlap zone. Requires odd values.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *3-99*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **difference_reach** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Look for maximum difference between surfaces in surrounding n cells from the edge  
    &nbsp;&nbsp;&nbsp;&nbsp;Recommended values between 3 and 9  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use spatially variable overlap  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input_a** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map A  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **input_b** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map B  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overlap** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for raster map of spatially variable overlap  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **blend_mask** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster containing edge of raster A which is not to be blended  
    &nbsp;&nbsp;&nbsp;&nbsp;Useful when raster A has common edge with raster B  
    **smooth_dist** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing distance in map units  
    **transition_angle** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of transition for spatially variable overlap  
    &nbsp;&nbsp;&nbsp;&nbsp;Recommended values between 1 and 5 degrees  
    **parallel_smoothing** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of smoothing window for smoothing edges of spatially variable overlap zone  
    &nbsp;&nbsp;&nbsp;&nbsp;Small value results in more rugged shape of the overlap zone, large values result in spatially non-variable overlap zone. Requires odd values.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *3-99*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **difference_reach** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Look for maximum difference between surfaces in surrounding n cells from the edge  
    &nbsp;&nbsp;&nbsp;&nbsp;Recommended values between 3 and 9  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use spatially variable overlap  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module fuses rasters representing elevation together by patching them
and smoothing values along edges using either fixed or spatially
variable overlap width. Spatially variable overlap width is given by the
difference along the edge between the two rasters. Higher difference
results in larger overlap width to smooth the transition.

r.patch.smooth can be used, for example, for updating older, lower
resolution DEM (**input\_b**) with newer, higher resolution DEM
(**input\_a**). Note that both DEMs must be aligned and have the same
resolution. Smoothing uses weighted averaging on the overlap of the
rasters. r.patch.smooth supports 2 types of smoothing. The default one
is simpler and uses fixed overlap width defined in **smooth\_dist**.
Since the differences along the seam line can vary, the second option
uses spatially variable overlap width and can be activated with flag
**-s**. The width is then computed based on the elevation differences
along the edge and transition angle **transition\_angle** controlling
the steepness of the transition. If option **overlap** is specified, a
map representing the spatially variable overlap is created and can be
used for inspecting the fusion results.

![image-alt](r_patch_smooth_overview.png)  
Difference between fixed overlap width and spatially variable overlap.

For spatially variable overlap, options **parallel\_smoothing** and
**difference\_reach** can be specified. Option **parallel\_smoothing**
smoothes the overlap zone in direction parallel to the edge. Option
**difference\_reach** enables to increase the sensitivity to higher
differences on the edges by taking maximum difference values in the
cells close to edges.

![image-alt](r_patch_smooth_parallel_smoothing.png)  
Effect of **parallel\_smoothing** option shown on overlap zone (created
by specifying **overlap** option). Image A shows result with value 3 and
B with value 9.

Option **blend\_mask** (experimental) can be used to specify which edges
of the input\_a DEM should be excluded from the blending. This is useful
when DEMs A and B have identical edges (on the coast, for example) and
we want to preserve only A (not blend it with B along the coast). The
**blend\_mask** raster can be created by digitizing area approximately
around the excluded edges, so that the edge of DEM A is inside the areas
and the rest are NULLs. This option requires more testing.

## SEE ALSO

[r.patch](https://grass.osgeo.org/grass-stable/manuals/r.patch.html),
[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html),
[r.grow.distance](https://grass.osgeo.org/grass-stable/manuals/r.grow.distance.html)

## REFERENCES

Anna Petrasova, Helena Mitasova, Vaclav Petras, Justyna Jeziorska.
[Fusion of high-resolution DEMs for water flow
modeling](https://link.springer.com/article/10.1186/s40965-017-0019-2)
(2017). Open Geospatial Data, Software and Standards. 2: 6.
[DOI: 10.1186/s40965-017-0019-2](https://doi.org/10.1186/s40965-017-0019-2)

## AUTHOR

Anna Petrasova, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.patch.smooth source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.patch.smooth)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.patch.smooth))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
