---
name: r.pi.enn.pr
description: Patch relevance for Euclidean Nearest Neighbor patches.
keywords: [ raster, landscape structure analysis, patch index ]
---

# r.pi.enn.pr

Patch relevance for Euclidean Nearest Neighbor patches.

=== "Command line"

    **r.pi.enn.pr**
    [**-a**]
    **input**=*name*
    **output**=*name*
    **keyval**=*integer*
    **method**=*string*
    **statmethod**=*string*
    [**title**=*"phrase"*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.enn.pr input=name output=name keyval=0 method=distance statmethod=sum
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.enn.pr***",
        **input**,
        **output**,
        **keyval**,
        **method**,
        **statmethod**,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.enn.pr", input="name", output="name", keyval=0, method="distance", statmethod="sum")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_enn_pr*(**input**,
        **output**,
        **keyval**,
        **method**,
        **statmethod**,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_enn_pr(input="name", output="name", keyval=0, method="distance", statmethod="sum")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **keyval**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value of patches in the input file  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Aspect of the nearest patch to use.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *distance, area*  
    **statmethod**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on differences.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sum, average*  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value of patches in the input file  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aspect of the nearest patch to use.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *distance, area*  
    **statmethod** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on differences.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sum, average*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Key value of patches in the input file  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aspect of the nearest patch to use.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *distance, area*  
    **statmethod** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on differences.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sum, average*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Patch relevance for Euclidean Nearest Neighbor patches.

*r.pi.enn.pr* computes distance and area differences for the first NN
after removal of patch i.

## NOTES

The *keyval* operator determines which category value is taken for the
Patch Index analysis.

The *method* operators determine what measure is applied on the nth NN
(area or distance).

Differences of distance/area after removal of patch i are provided as
output as well as the amount of patches to be affected by its removal
(percent) (PP) and the amount of area in these patches (PA - Percent
Area)

## EXAMPLE

An example for the North Carolina sample dataset:

Analysing the differences (average) in distance when patch i of class 5
is removed:

```sh
r.pi.enn.pr input=landclass96 output=dist_iter keyval=5 method=distance statmethod=average
```

## SEE ALSO

*[r.pi.index](r.pi.index.md), [r.pi.enn](r.pi.enn.md),
[r.pi.fnn](r.pi.fnn.md), [r.pi.searchtime.pr](r.pi.searchtime.pr.md),
[r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.enn.pr source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.enn.pr)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.enn.pr))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
