---
name: r.pi.import
description: Import and generation of patch raster data
keywords: [ raster, landscape structure analysis, patch index ]
---

# r.pi.import

Import and generation of patch raster data

=== "Command line"

    **r.pi.import**
    [**-a**]
    **input**=*string*
    **raster**=*name*
    **output**=*name*
    **keyval**=*integer*
    **id_col**=*integer*
    **val_col**=*integer*
    [**title**=*"phrase"*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.import input=string raster=name output=name keyval=0 id_col=0 val_col=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.import***",
        **input**,
        **raster**,
        **output**,
        **keyval**,
        **id_col**,
        **val_col**,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.import", input="string", raster="name", output="name", keyval=0, id_col=0, val_col=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_import*(**input**,
        **raster**,
        **output**,
        **keyval**,
        **id_col**,
        **val_col**,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_import(input="string", raster="name", output="name", keyval=0, id_col=0, val_col=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input ASCII-file  
    **raster**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **keyval**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value of the patches  
    **id_col**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of the column with patch IDs  
    **val_col**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of the column with patch values  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input ASCII-file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input  
    **raster** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value of the patches  
    **id_col** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of the column with patch IDs  
    **val_col** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of the column with patch values  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input ASCII-file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input  
    **raster** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value of the patches  
    **id_col** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of the column with patch IDs  
    **val_col** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of the column with patch values  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Import and generation of patch raster data based on individual patch
based raster data.

## NOTES

...

## EXAMPLE

An example for the North Carolina sample dataset: In order to run
*r.pi.import* we need an exported patch index raster:

```sh
r.pi.index input=landclass96 output=landclass96_forestclass5_area keyval=5 method=area
```

export this resulting map:

```sh
r.pi.export input=landclass96_forestclass5_area output=patch_area_out values=patch_area_values id_raster=forestclass5_ID stats=average,variance,min
```

modify it with R or just import the file again and assign the percentage
coverage to each fragment. You need the *patch\_area\_values* file and
the previously used input file *forestclass96* raster (important: the
same patch coverage is mandatory otherwise patch ID in the text file and
raster are not congruent\!):

```sh
r.pi.import input=patch_area_values raster=landclass96 output=imported_values keyval=5 id_col=1 val_col=2
```

if you want to export the patch values to R and do e.g. a linear
regression of two patch values and import them again in GRASS, do:  
apply r.pi.export with two indices (A and B), in `R`, do:

```R
resid.AB <- resid(lm(A[,3]~B[,3])) #write residuals of a linear regression
df.resid.AB <- data.frame(A[,1],resid.AB) #merge patch IDs and resid into same data frame
write.table(df.resid.AB,"resid.for.GRASS",row.names=F,col.names=F)
```

exit R and run in GRASS:

```sh
r.pi.import input=resid.for.GRASS raster=landclass96 output=resid.AB keyval=5 id_col=1 val_col=2
```

## SEE ALSO

*[r.pi.export](r.pi.export.md), [r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.import source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.import)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.import))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
