---
name: r.pi.index
description: Basic patch based indices
keywords: [ raster, landscape structure analysis, fragmentation analysis ]
---

# r.pi.index

Basic patch based indices

=== "Command line"

    **r.pi.index**
    [**-a**]
    **input**=*name*
    **output**=*name*
    **keyval**=*integer*
    **method**=*string*
    [**title**=*"phrase"*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.index input=name output=name keyval=0 method=area
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.index***",
        **input**,
        **output**,
        **keyval**,
        **method**,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.index", input="name", output="name", keyval=0, method="area")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_index*(**input**,
        **output**,
        **keyval**,
        **method**,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_index(input="name", output="name", keyval=0, method="area")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing categories  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output patch-based result as raster map  
    **keyval**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The value of the class to be analysed  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area, perimeter, shape, border, compactness, asymmetry, area-perimeter, fractal, ENN*  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing categories  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output patch-based result as raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value of the class to be analysed  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area, perimeter, shape, border, compactness, asymmetry, area-perimeter, fractal, ENN*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing categories  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output patch-based result as raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value of the class to be analysed  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to perform on fragments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area, perimeter, shape, border, compactness, asymmetry, area-perimeter, fractal, ENN*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.pi.index* is a patch based fragmentation analysis package.
Computation of basic fragmentation indices can be accomplished.

Available options for the index to be computed for patches within a
certain class are: area (area), perimeter (perim), SHAPE (shape),
Border-Index (bor), Compactness (comp), Asymmetry (asym), area-perimeter
ratio (apr), fractal dimension (fract), distance to euclidean nearest
neighbour (ENN).

## NOTES

The *Nearest Neighbour Index* (ENN) analyse the Euclidean Nearest
Neighbour to the first neighbouring patch. The output value is in pixel
and can be converted to a distance values using g.region resolution
information. *r.pi.enn* and *r.pi.fnn* provide the same analysis
concerning the first nearest neighbour (NN), but are extended to the
n-th NN. However due to code construction does the *r.pi.index* distance
analysis to first ENN perform faster. *Methods:* The *method* operators
determine what algorithm is applied on the patches. *r.pi.index* can
perform the following operations:

- **Area**  
    The *Area* computes the area of each patch.
- **Perimeter**  
    The *Perimeter* computes the perimeter of each patch.
- **Area-Perimeter ratio**  
    The *Area-Perimeter ratio* divides the patch perimeter by the area.
- **SHAPE Index**  
    The *SHAPE Index* divides the patch perimete by the minimum
    perimeter possible for a maximally compact patch of the
    corresponding patch area.
- **Border Index**  
    The *Border Index* ....
- **Compactness Index**  
    The *Compactness Index* ....
- **Asymmetry Index**  
    The *Border Index* ....
- **Fractal Dimension Index**  
    The *Fractal Dimension Index* ....
- **Nearest Neighbour Index**  
    The *Nearest Neighbour Index* computes the Euclidean distance to the
    first nearest neighbour patch.

## EXAMPLE

Examples based on the North Carolina sample dataset are provided below.
Indices are calculated for the landscape class 5 (forest). set region
settings to used landcover class map:  

```sh
g.region rast=landclass96
```

computation of patch size (patch definition: 4-neighbourhood rule)

```sh
r.pi.index input=landclass96 output=landclass96_forestclass5_area keyval=5 method=area
# improve colouring of resulting map:
r.colors landclass96_forestclass5_area col=bgyr
```

computation of patch size (patch definition: 8-neighbourhood rule)

```sh
r.pi.index input=landclass96 output=landclass96_forestclass5_area keyval=5 method=area -a
```

computation of patch isolation (euclidean distance to 1. nearest
neighbour; patch definition: 4-neighbourhood rule)

```sh
r.pi.index input=landclass96 output=landclass96_forestclass5_ENN keyval=5 method=ENN -a
```

## SEE ALSO

*[r.pi.enn](r.pi.enn.md), [r.pi.import](r.pi.import.md),
[r.pi.rectangle](r.pi.rectangle.md), [r.pi](r.pi.md)*

## BUGS

Landscapes with more than 10 000 individual patches might cause a memory
allocation error depending on the user's system.

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.index source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.index)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.index))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
