---
name: r.pi.nlm.circ
description: Creates a random landscape with defined attributes.
keywords: [ raster, landscape structure analysis, neutral landscapes ]
---

# r.pi.nlm.circ

Creates a random landscape with defined attributes.

=== "Command line"

    **r.pi.nlm.circ**
    **output**=*name*
    **size**=*x,y*
    **landcover**=*float*
    **count**=*integer*
    [**seed**=*integer*]
    [**title**=*"phrase"*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.nlm.circ output=name size=0 landcover=0.0 count=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.nlm.circ***",
        **output**,
        **size**,
        **landcover**,
        **count**,
        **seed**=*None*,
        **title**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.nlm.circ", output="name", size=0, landcover=0.0, count=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_nlm_circ*(**output**,
        **size**,
        **landcover**,
        **count**,
        **seed**=*None*,
        **title**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_nlm_circ(output="name", size=0, landcover=0.0, count=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **size**=*x,y* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of the map  
    **landcover**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Landcover in percent  
    **count**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of the patches to create  
    **seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **size** : tuple[int, int] | list[int] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of the map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    **landcover** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Landcover in percent  
    **count** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of the patches to create  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **size** : tuple[int, int] | list[int] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of the map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    **landcover** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Landcover in percent  
    **count** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of the patches to create  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.pi.nlm.circ* is a random patch generator. It creates a random
landscape with defined attributes.

## NOTES

The user must specify the names of the raster map layers to be used for
*input* and *output*, the *landcover*, the *size*, the *count* used, the
*keyval* of the class of interest of the input raster map.

- **Input**  
    The *Input* is potentially used for Landcover, size and count.
- **keyval**  
    The *keyval* is used to compute landcover and count if not declared.
- **landcover**  
    The *landcover* defines the amount of cover, if not declared, the
    landcover of keyval of input is used.
- **count**  
    The *count* defines the amount of patches in the landscape, if not
    defined, the amount of patches in the input is used, if 0 is
    inserted, random amount of patches are created. Values from 1-n can
    be defined for a fixed number of patches.
- **size**  
    The *size* defines the size of the artificial landscape. If not
    declared the size of the actual region is taken.
- **seed**  
    The *seed* defiens the seed of random points. If all settings and
    the seed is fixed, then the patches won't be random anymore, but
    fixed. The user will receive everytime the same landscape.
- **xxx**  
    The *xxx* ....
- **xxx**  
    The *xxx* ....

## EXAMPLE

An example for the North Carolina sample dataset:

```sh
g.region -d
...
```

## SEE ALSO

*[r.pi.nlm](r.pi.nlm.md), [r.pi.nlm.stats](r.pi.nlm.stats.md),
[r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.nlm.circ source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.nlm.circ)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.nlm.circ))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
