---
name: r.pi.searchtime.mw
description: Individual-based dispersal model for connectivity analysis (time-based) using moving window
keywords: [ raster, landscape structure analysis, connectivity analysis ]
---

# r.pi.searchtime.mw

Individual-based dispersal model for connectivity analysis (time-based) using moving window

=== "Command line"

    **r.pi.searchtime.mw**
    [**-ac**]
    **input**=*name*
    [**suitability**=*string*]
    **output**=*name*
    [**out_immi**=*string*]
    **keyval**=*integer*
    **step_length**=*integer*
    [**perception**=*integer*]
    [**multiplicator**=*float*]
    **n**=*integer*
    **percent**=*float*
    **stats**=*string* [,*string*,...]
    [**maxsteps**=*integer*]
    [**size**=*integer*]
    [**title**=*"phrase"*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.searchtime.mw input=name output=name keyval=0 step_length=0 n=0 percent=0.0 stats=average
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.searchtime.mw***",
        **input**,
        **suitability**=*None*,
        **output**,
        **out_immi**=*None*,
        **keyval**,
        **step_length**,
        **perception**=*None*,
        **multiplicator**=*None*,
        **n**,
        **percent**,
        **stats**,
        **maxsteps**=*None*,
        **size**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.searchtime.mw", input="name", output="name", keyval=0, step_length=0, n=0, percent=0.0, stats="average")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_searchtime_mw*(**input**,
        **suitability**=*None*,
        **output**,
        **out_immi**=*None*,
        **keyval**,
        **step_length**,
        **perception**=*None*,
        **multiplicator**=*None*,
        **n**,
        **percent**,
        **stats**,
        **maxsteps**=*None*,
        **size**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_searchtime_mw(input="name", output="name", keyval=0, step_length=0, n=0, percent=0.0, stats="average")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **suitability**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the costmap with values from 0-100  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **out_immi**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the optional raster file for patch immigrants count  
    **keyval**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value of the patches  
    **step_length**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of a single step measured in pixels  
    **perception**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Perception range  
    **multiplicator**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attractivity of patches [1-inf]  
    **n**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of individuals  
    **percent**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of individuals which must have arrived successfully to stop the model-run  
    **stats**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the pathlengths of the individuals  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, median, min, max*  
    **maxsteps**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum steps for each individual  
    **size**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of the moving window  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Include cost of the path in the calculation of steps  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **suitability** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the costmap with values from 0-100  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **out_immi** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the optional raster file for patch immigrants count  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value of the patches  
    **step_length** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of a single step measured in pixels  
    **perception** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Perception range  
    **multiplicator** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attractivity of patches [1-inf]  
    **n** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of individuals  
    **percent** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of individuals which must have arrived successfully to stop the model-run  
    **stats** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the pathlengths of the individuals  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, median, min, max*  
    **maxsteps** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum steps for each individual  
    **size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of the moving window  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include cost of the path in the calculation of steps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **suitability** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the costmap with values from 0-100  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **out_immi** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the optional raster file for patch immigrants count  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **keyval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value of the patches  
    **step_length** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of a single step measured in pixels  
    **perception** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Perception range  
    **multiplicator** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attractivity of patches [1-inf]  
    **n** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of individuals  
    **percent** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of individuals which must have arrived successfully to stop the model-run  
    **stats** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the pathlengths of the individuals  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, median, min, max*  
    **maxsteps** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum steps for each individual  
    **size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of the moving window  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include cost of the path in the calculation of steps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Analysis of landscape connectivity using individual-based dispersal
model inside a moving window. This module provides information about the
patch connectivity within a moving window.

## NOTES

The suitability matrix impacts the step direction of individuals. If
individuals are moving beyond the mapset borders the indivuals are set
back to their original source patches.

## EXAMPLE

An example for the North Carolina sample dataset: The patch relevance
concerning connectivity are based on patches of the *landclass96* raster
class 5 amd the time (amount of steps) from emigration to immigration is
computed. The step length is set to 5 pixel, the output statistics are
set to *average* time and *variance* of searchtime. For each patch 1000
individuals were released and the model stopped when at least 80% of all
individuals sucessfully immigrated. The command below is computing the
time for the whole landscape and the result is prompted to the screen  

```sh
r.pi.searchtime.mw input=landclass96 output=searchtime_mw1 keyval=5 step_length=5 stats=average,variance percent=80 n=1000
```

for a graphical output a moving window size needs to be defined (here
7x7 pixel) and the amount of steps until immigration per moving window
is provided in the output raster:

```sh
r.pi.searchtime.mw input=landclass96 output=searchtime_mw1 keyval=5 step_length=5 stats=average,variance percent=80 n=1000 size=7
```

setting the perception range to 10 pixel:

```sh
r.pi.searchtime.mw input=landclass96 output=searchtime_mw1 keyval=5 step_length=5 stats=average,variance percent=80 n=1000 size=7 perception=10
```

increasing the attraction to move towards patches to 10:

```sh
r.pi.searchtime.mw input=landclass96 output=searchtime_mw1 keyval=5 step_length=5 stats=average,variance percent=80 n=1000 size=7 multiplicator=10
```

the previous examples assumed a homogeneous matrix, a heterogenous
matrix can be included using a raster file which values are taken as
costs for movement (0-100):

```sh
# it is assumed that our species is a forest species and cannot move
# through water, hence a cost of 100, does not like urban areas (class:
# 6, cost: 10) but can disperse through shrubland (class 4, cost=1)
# better than through grassland (class 3, cost: 2):
r.mapcalc "suit_raster = if(landclass96==5,1,if(landclass96 == 1, 10, if (landclass96==3,2, if(landclass96==4,1,if(landclass96==6,100)))))"
r.pi.searchtime.mw input=landclass96 output=searchtime1 keyval=5 step_length=5 stats=average,variance percent=80 n=1000 size=7 suitability=suit_raster
```

## SEE ALSO

*[r.pi.searchtime](r.pi.searchtime.md),
[r.pi.searchtime.pr](r.pi.searchtime.pr.md), [r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.searchtime.mw source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.searchtime.mw)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.searchtime.mw))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
