---
name: r.popgrowth.py
description: Set of population models (fisheries science)
keywords: [ Population growth model ]
---

# r.popgrowth.py

Set of population models (fisheries science)

=== "Command line"

    **r.popgrowth.py**
    [**-i**]
    **n_initial**=*string*
    **timesteps**=*integer*
    [**exponential_output**=*name*]
    [**r_exp_value**=*float*]
    [**r_exp_map**=*string*]
    [**ricker_output**=*name*]
    [**k_value**=*integer*]
    [**k_map**=*string*]
    [**r_rick_value**=*float*]
    [**r_rick_map**=*string*]
    [**population_patches**=*string*]
    [**seed**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.popgrowth.py n_initial=string timesteps=1
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.popgrowth.py***",
        **n_initial**,
        **timesteps**=*1*,
        **exponential_output**=*None*,
        **r_exp_value**=*None*,
        **r_exp_map**=*None*,
        **ricker_output**=*None*,
        **k_value**=*None*,
        **k_map**=*None*,
        **r_rick_value**=*None*,
        **r_rick_map**=*None*,
        **population_patches**=*None*,
        **seed**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.popgrowth.py", n_initial="string", timesteps=1)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_popgrowth_py*(**n_initial**,
        **timesteps**=*1*,
        **exponential_output**=*None*,
        **r_exp_value**=*None*,
        **r_exp_map**=*None*,
        **ricker_output**=*None*,
        **k_value**=*None*,
        **k_map**=*None*,
        **r_rick_value**=*None*,
        **r_rick_map**=*None*,
        **population_patches**=*None*,
        **seed**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_popgrowth_py(n_initial="string", timesteps=1)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **n_initial**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of number of individuals per cell at time t0 (initial population size)  
    **timesteps**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of time steps  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **exponential_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for exponential model output map  
    **r_exp_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell-specific fixed value of intrinsic rate of increase, log(finite rate of increase, lambda)  
    **r_exp_map**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of cell-specific intrinsic rate of increase, log(finite rate of increase, lambda)  
    **ricker_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for Ricker model output map  
    **k_value**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fixed value of carrying capacity of the environment (per cell)  
    **k_map**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of carrying capacity of the environment (per cell)  
    **r_rick_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell-specific fixed value of intrinsic rate of increase (Ricker)  
    **r_rick_map**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of cell-specific intrinsic rate of increase (Ricker)  
    **population_patches**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional raster map of patches of single populations. If provided, growth models are calculated based on these patches (patch-averaged r and cumulated k).  
    **seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;fixed seed for random rounding  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Calculate models with rounded integer values  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **n_initial** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of number of individuals per cell at time t0 (initial population size)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **timesteps** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of time steps  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **exponential_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for exponential model output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **r_exp_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell-specific fixed value of intrinsic rate of increase, log(finite rate of increase, lambda)  
    **r_exp_map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of cell-specific intrinsic rate of increase, log(finite rate of increase, lambda)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **ricker_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for Ricker model output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **k_value** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fixed value of carrying capacity of the environment (per cell)  
    **k_map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of carrying capacity of the environment (per cell)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **r_rick_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell-specific fixed value of intrinsic rate of increase (Ricker)  
    **r_rick_map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of cell-specific intrinsic rate of increase (Ricker)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **population_patches** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional raster map of patches of single populations. If provided, growth models are calculated based on these patches (patch-averaged r and cumulated k).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;fixed seed for random rounding  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate models with rounded integer values  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **n_initial** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of number of individuals per cell at time t0 (initial population size)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **timesteps** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of time steps  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **exponential_output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for exponential model output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **r_exp_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell-specific fixed value of intrinsic rate of increase, log(finite rate of increase, lambda)  
    **r_exp_map** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of cell-specific intrinsic rate of increase, log(finite rate of increase, lambda)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **ricker_output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for Ricker model output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **k_value** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fixed value of carrying capacity of the environment (per cell)  
    **k_map** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of carrying capacity of the environment (per cell)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **r_rick_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell-specific fixed value of intrinsic rate of increase (Ricker)  
    **r_rick_map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of cell-specific intrinsic rate of increase (Ricker)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **population_patches** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional raster map of patches of single populations. If provided, growth models are calculated based on these patches (patch-averaged r and cumulated k).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;fixed seed for random rounding  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate models with rounded integer values  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.popgrow* calculates classical models of population growths. The
module creates a new raster map of population size (abundance) after a
specified number of time steps based on an intial populations size
(input raster).

Available models for populations growth: Exponential growth and the
Ricker model.

## EXAMPLES

TBD.

## SEE ALSO

## AUTHOR

Johannes Radinger  
*Leibniz-Institute of Freshwater Ecology and Inland Fisheries (IGB)  
Berlin, Germany*

## SOURCE CODE

Available at: [r.popgrowth source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.popgrowth)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.popgrowth))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
