---
name: r.regression.series
description: Makes each output cell value a function of the values assigned to the corresponding cells in the input raster map layers.
keywords: [ raster, statistics, series, regression ]
---

# r.regression.series

Makes each output cell value a function of the values assigned to the corresponding cells in the input raster map layers.

=== "Command line"

    **r.regression.series**
    [**-n**]
    **xseries**=*name* [,*name*,...]
    **yseries**=*name* [,*name*,...]
    **output**=*name* [,*name*,...]
    **method**=*string* [,*string*,...]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.regression.series xseries=name yseries=name output=name method=slope
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.regression.series***",
        **xseries**,
        **yseries**,
        **output**,
        **method**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.regression.series", xseries="name", yseries="name", output="name", method="slope")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_regression_series*(**xseries**,
        **yseries**,
        **output**,
        **method**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_regression_series(xseries="name", yseries="name", output="name", method="slope")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **xseries**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    **yseries**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    **output**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **method**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Regression parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *slope, offset, corcoef, rsq, adjrsq, f, t*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Propagate NULLs  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **xseries** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **yseries** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **method** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regression parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *slope, offset, corcoef, rsq, adjrsq, f, t*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Propagate NULLs  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **xseries** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **yseries** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **method** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regression parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *slope, offset, corcoef, rsq, adjrsq, f, t*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Propagate NULLs  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.regression.series* is a module to calculate linear regression
parameters between two time series, e.g. NDVI and precipitation.

The module makes each output cell value a function of the values
assigned to the corresponding cells in the two input raster map series.
Following methods are available:

- offset: Linear regression offset
- slope: Linear regression slope
- corcoef: Correlation Coefficent R
- rsq: Coefficient of determination = R squared
- adjrsq: Adjusted coefficient of determination
- f: F statistic
- t: T statistic

The module assumes a simple linear regression of the form

```sh
    y = a + b * x
```

*offset* is equivalent to *a* in the above equation, also referred to as
constant or intercept.

*slope* is equivalent to *b* in the above equation.

*corcoef* is the correlation coefficient R with a theoretical range of
-1,1.

*rsq* is the coefficient of determination, equivalent to the squared
correlation coefficient R<sup>2</sup>.

*adjrsq* is the coefficient of determination adjusted for the number of
samples, i.e. number of input maps per series.

*f* is the value of the F statistic.

*t* is the value of the T statistic.

## NOTES

The number of maps in *xseries* and *yseries* must be identical.

With *-n* flag, any cell for which any of the corresponding input cells
are NULL is automatically set to NULL (NULL propagation). The aggregate
function is not called, so all methods behave this way with respect to
the *-n* flag.

Without *-n* flag, the complete list of inputs for each cell (including
NULLs) is passed to the function. Individual functions can handle data
as they choose. Mostly, they just compute the parameter over the
non-NULL values, producing a NULL result only if all inputs are NULL.

Linear regression (slope, offset, coefficient of determination) requires
an equal number of *xseries* and *yseries* maps. If the different time
series have irregular time intervals, NULL raster maps can be inserted
into time series to make time intervals equal (see example).

The maximum number of raster maps to be processed is limited by the
operating system. For example, both the hard and soft limits are
typically 1024. The soft limit can be changed with e.g. `ulimit -n 1500`
(UNIX-based operating systems) but not higher than the hard limit. If it
is too low, you can as superuser add an entry in

```sh
/etc/security/limits.conf
# <domain>      <type>  <item>         <value>
your_username  hard    nofile          1500
```

This would raise the hard limit to 1500 file. Be warned that more files
open need more RAM.

## EXAMPLES

Using *r.regression.series* with wildcards:  

```sh
r.regression.series xseries="`g.list pattern='insitu_data.*' sep=,`" \
     yseries="`g.list pattern='invivo_data.*' sep=,`" \
         output=insitu_data.rsquared method=rsq
```

Note the *g.list* module also supports regular expressions for selecting
map names.

Example for multiple parameters to be computed in one run (3 resulting
parameters from 8 input maps, 4 maps per time series):

```sh
r.regression.series x=xone,xtwo,xthree,xfour y=yone,ytwo,ythree,yfour \
    out=res_offset,res_slope,res_adjrsq meth=offset,slope,adjrsq
```

## SEE ALSO

*[g.list](https://grass.osgeo.org/grass-stable/manuals/g.list.html),
[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html),
[r.series](https://grass.osgeo.org/grass-stable/manuals/r.series.html),
[r.regression.line](https://grass.osgeo.org/grass-stable/manuals/r.regression.line.html),
[r.regression.multi](https://grass.osgeo.org/grass-stable/manuals/r.regression.multi.html)*

## AUTHOR

Markus Metz

## SOURCE CODE

Available at: [r.regression.series source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.regression.series)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.regression.series))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
