---
name: r.richdem.terrainattribute.py
description: Calculates local terrain attributes.
keywords: [ raster ]
---

# r.richdem.terrainattribute.py

Calculates local terrain attributes.

=== "Command line"

    **r.richdem.terrainattribute.py**
    **input**=*name*
    **attribute**=*string*
    [**zscale**=*float*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.richdem.terrainattribute.py input=name attribute=slope_riserun output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.richdem.terrainattribute.py***",
        **input**,
        **attribute**,
        **zscale**=*1.0*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.richdem.terrainattribute.py", input="name", attribute="slope_riserun", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_richdem_terrainattribute_py*(**input**,
        **attribute**,
        **zscale**=*1.0*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_richdem_terrainattribute_py(input="name", attribute="slope_riserun", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **attribute**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Terrain attribute to calculate.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *slope_riserun, slope_percentage, slope_degrees, slope_radians, aspect, curvature, planform_curvature, profile_curvature*  
    **zscale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scalar multiplier for elevation (vertical exaggeration)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output DEM with depressions filled  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **attribute** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Terrain attribute to calculate.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *slope_riserun, slope_percentage, slope_degrees, slope_radians, aspect, curvature, planform_curvature, profile_curvature*  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scalar multiplier for elevation (vertical exaggeration)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output DEM with depressions filled  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **attribute** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Terrain attribute to calculate.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *slope_riserun, slope_percentage, slope_degrees, slope_radians, aspect, curvature, planform_curvature, profile_curvature*  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scalar multiplier for elevation (vertical exaggeration)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output DEM with depressions filled  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

PLACEHOLDER

## REFERENCES

PLACEHOLDER

## SEE ALSO

[r.fill.dir](https://grass.osgeo.org/grass-stable/manuals/r.fill.dir)  

## AUTHORS

Richard Barnes (algorithm and codebase), Andrew D. Wickert (GRASS
frontend)

## SOURCE CODE

Available at: [r.richdem.terrainattribute source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.richdem.terrainattribute)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.richdem.terrainattribute))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
