---
name: r.sample.category.py
description: Create sampling points from each category in a raster map
keywords: [ raster, sampling, random, points, vector, stratified random sampling, category ]
---

# r.sample.category.py

Create sampling points from each category in a raster map

=== "Command line"

    **r.sample.category.py**
    [**-s**]
    **input**=*name*
    **output**=*name*
    [**sampled**=*name* [,*name*,...]]
    **npoints**=*integer* [,*integer*,...]
    [**random_seed**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.sample.category.py input=name output=name npoints=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.sample.category.py***",
        **input**,
        **output**,
        **sampled**=*None*,
        **npoints**,
        **random_seed**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.sample.category.py", input="name", output="name", npoints=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_sample_category_py*(**input**,
        **output**,
        **sampled**=*None*,
        **npoints**,
        **random_seed**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_sample_category_py(input="name", output="name", npoints=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map with categories (classes)  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output vector map with points at random locations  
    **sampled**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of input raster maps to be sampled  
    **npoints**=*integer* [,*integer*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of sampling points per category in the input map  
    &nbsp;&nbsp;&nbsp;&nbsp;You can provide multiple numbers, one for each category in input raster (sorted ascending)  
    **random_seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;If number of cells in category &lt; npoints, skip category  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map with categories (classes)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output vector map with points at random locations  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **sampled** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of input raster maps to be sampled  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **npoints** : int | list[int] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of sampling points per category in the input map  
    &nbsp;&nbsp;&nbsp;&nbsp;You can provide multiple numbers, one for each category in input raster (sorted ascending)  
    **random_seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;If number of cells in category &lt; npoints, skip category  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map with categories (classes)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output vector map with points at random locations  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **sampled** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of input raster maps to be sampled  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **npoints** : int | list[int] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of sampling points per category in the input map  
    &nbsp;&nbsp;&nbsp;&nbsp;You can provide multiple numbers, one for each category in input raster (sorted ascending)  
    **random_seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;If number of cells in category &lt; npoints, skip category  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.sample.category* generates points at random locations. Each category
(class) in a raster map will contain specified number of random points.

Different number of points can be specified for different categories.
For example, if there are categories 1, 4, 7 in the input raster map,
and npoints=100,200,300, 100 points will be generated in category 1, 200
points in category 4 and 300 points in category 7. If only one number is
specified, it will be used for every category.

## NOTES

Mask
(*[r.mask](https://grass.osgeo.org/grass-stable/manuals/r.mask.html)*)
to create points in areas with each category, thus mask cannot be active
when the module is used.

Categories are identified based on current computational region.

## EXAMPLE

### Generate random points

Generate three points at random location for each category (class) in
the raster map:

```sh
g.region raster=landclass96
r.sample.category input=landclass96 output=landclass_points npoints=3
```

Show the result:

```sh
d.rast map=landclass96
d.vect map=landclass_points icon=basic/circle fill_color=aqua color=blue size=10
```

![image-alt](r.sample.category.png)  
Figure: Three random points in each category of landclass raster map

### Create a table with values sampled from rasters

Create 2 random points per each category (class) in landclass96 raster
and sample elevation and geology\_30m rasters at these points:

```sh
r.sample.category input=landclass96 output=landclass_points sampled=elevation,geology_30m npoints=2
```

Look at the created data:

```sh
v.db.select landclass_points sep=comma
```

The result of
*[v.db.select](https://grass.osgeo.org/grass-stable/manuals/v.db.select.html)*
is CSV table which can be used, for example in a spreadsheet
application:

```csv
cat,landclass96,elevation,geology_30m
1,1,102.7855,270
2,1,105.78,270
3,2,114.5954,217
4,2,137.4816,921
5,3,71.19167,270
6,3,93.33904,270
7,4,76.41077,262
8,4,97.54424,217
9,5,138.455,405
10,5,88.8075,270
11,6,126.5298,217
12,6,86.73177,217
13,7,134.5381,217
14,7,99.6844,270
```

## SEE ALSO

*[v.sample](https://grass.osgeo.org/grass-stable/manuals/v.sample.html),
[r.random](https://grass.osgeo.org/grass-stable/manuals/r.random.html),
[r.random.cells](https://grass.osgeo.org/grass-stable/manuals/r.random.cells.html),
[v.random](https://grass.osgeo.org/grass-stable/manuals/v.random.html),
[v.what.rast](https://grass.osgeo.org/grass-stable/manuals/v.what.rast.html),
[r.describe](https://grass.osgeo.org/grass-stable/manuals/r.describe.html)*

## AUTHORS

Vaclav Petras, [NCSU OSGeoREL](http://gis.ncsu.edu/osgeorel/),  
Anna Petrasova, [NCSU OSGeoREL](http://gis.ncsu.edu/osgeorel/)

## SOURCE CODE

Available at: [r.sample.category source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.sample.category)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.sample.category))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
