---
name: r.surf.idw2
description: Provides surface interpolation from raster point data by Inverse Distance Squared Weighting.
keywords: [ raster, surface, interpolation, IDW ]
---

# r.surf.idw2

Provides surface interpolation from raster point data by Inverse Distance Squared Weighting.

=== "Command line"

    **r.surf.idw2**
    **input**=*name*
    **output**=*name*
    [**npoints**=*count*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.surf.idw2 input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.surf.idw2***",
        **input**,
        **output**,
        **npoints**=*12*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.surf.idw2", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_surf_idw2*(**input**,
        **output**,
        **npoints**=*12*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_surf_idw2(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **npoints**=*count*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation points  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **npoints** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *count*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **npoints** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *count*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.surf.idw2* fills a raster matrix with interpolated values generated
from a set of irregularly spaced data points using numerical
approximation (weighted averaging) techniques. The interpolated value of
a cell is determined by values of nearby data points and the distance of
the cell from those input points. In comparison with other methods,
numerical approximation allows representation of more complex surfaces
(particularly those with anomalous features), restricts the spatial
influence of any errors, and generates the interpolated surface from the
data points. It is the most appropriate method to apply to most spatial
data. The **npoints** parameter defines the number of points to use for
interpolation. The default is to use the 12 nearest points when
interpolating the value for a particular cell.

## NOTES

The amount of memory used by this program is related to the number of
non-zero data values in the input map layer. If the input raster map
layer is very dense (i.e., contains many non-zero data points), the
program may not be able to get all the memory it needs from the system.
The time required to execute increases with the number of input data
points.

If the user has a mask set, then interpolation is only done for those
cells that fall within the mask. However, all non-zero data points in
the input layer are used even if they fall outside the mask.

This program does not work with latitude/longitude data bases. Another
surface generation program, named
*[r.surf.idw](https://grass.osgeo.org/grass-stable/manuals/r.surf.idw.html)*,
should be used with latitude/longitude data bases.

The user should refer to the manual entries for  
*[r.surf.idw](https://grass.osgeo.org/grass-stable/manuals/r.surf.idw.html)*  
*[r.surf.contour](https://grass.osgeo.org/grass-stable/manuals/r.surf.contour.html)*  
*[v.surf.rst](https://grass.osgeo.org/grass-stable/manuals/v.surf.rst.html)*  
to compare this surface generation program with others available in
GRASS.

## KNOWN ISSUES

Module *r.surf.idw* works only for integer (CELL) raster maps.

## SEE ALSO

*[r.surf.contour](https://grass.osgeo.org/grass-stable/manuals/r.surf.contour.html),
[r.surf.idw](https://grass.osgeo.org/grass-stable/manuals/r.surf.idw.html),
[r.surf.gauss](https://grass.osgeo.org/grass-stable/manuals/r.surf.gauss.html),
[r.surf.fractal](https://grass.osgeo.org/grass-stable/manuals/r.surf.fractal.html),
[r.surf.random](https://grass.osgeo.org/grass-stable/manuals/r.surf.random.html),
[r.surf.idw2](https://grass.osgeo.org/grass-stable/manuals/r.surf.idw2.html),
[v.surf.rst](https://grass.osgeo.org/grass-stable/manuals/v.surf.rst.html)*

## AUTHOR

Michael Shapiro, U.S.Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [r.surf.idw2 source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.surf.idw2)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.surf.idw2))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
