---
name: r.tpi.py
description: Calculates the multiscale topographic position index
keywords: [ raster, surface, terrain, topography ]
---

# r.tpi.py

Calculates the multiscale topographic position index

=== "Command line"

    **r.tpi.py**
    **input**=*name*
    **minradius**=*integer*
    **maxradius**=*integer*
    **steps**=*integer*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.tpi.py input=name minradius=1 maxradius=31 steps=5 output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.tpi.py***",
        **input**,
        **minradius**=*1*,
        **maxradius**=*31*,
        **steps**=*5*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.tpi.py", input="name", minradius=1, maxradius=31, steps=5, output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_tpi_py*(**input**,
        **minradius**=*1*,
        **maxradius**=*31*,
        **steps**=*5*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_tpi_py(input="name", minradius=1, maxradius=31, steps=5, output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEM from which to calculate mTPI  
    **minradius**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing neighborhood radius size (minimum)  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum neighborhood radius in cells for DEM smoothing  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **maxradius**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing neighborhood radius size (maximum)  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum neighborhood radius in cells for DEM smoothing  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *31*  
    **steps**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of scaling steps  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to use for DEM generalization between minradius and maxradius  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Multi-scale topographic position index  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEM from which to calculate mTPI  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **minradius** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing neighborhood radius size (minimum)  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum neighborhood radius in cells for DEM smoothing  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **maxradius** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing neighborhood radius size (maximum)  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum neighborhood radius in cells for DEM smoothing  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *31*  
    **steps** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of scaling steps  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to use for DEM generalization between minradius and maxradius  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multi-scale topographic position index  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Input DEM from which to calculate mTPI  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **minradius** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing neighborhood radius size (minimum)  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum neighborhood radius in cells for DEM smoothing  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **maxradius** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing neighborhood radius size (maximum)  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum neighborhood radius in cells for DEM smoothing  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *31*  
    **steps** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of scaling steps  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to use for DEM generalization between minradius and maxradius  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multi-scale topographic position index  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.tpi*calculates a multiscale version of the Topographic Position Index
(TPI) of Guisan et al. (1999). The TPI is calculated by averaging a DEM
over a user-specified moving window size and subtracting the original
DEM from the averaged version to get the residual. This has the effect
of extracting finer-scale landforms from regional-scale relief. Positive
TPI values represent ridges or hills, and negative TPI values represent
valleys or pits.

Unlike the original TPI, *r.tpi* implements a multiscale version that
calculates a standardized TPI over multiple neighborhood radii from
*minradius* to *maxradius*, starting at the largest neighborhood size.
For subsequent steps, the standardized TPI is updated with pixels where
the absolute TPI values exceed the TPI values of the previous step. For
large neighborhoods \> 15, resampling is used rather than a focal
function to generalize the DEM.

## EXAMPLE

```sh
g.region raster=elevation@PERMANENT -a
r.tpi input=elevation@PERMANENT minradius=1 maxradius=25 steps=5 output=tpi
```

![image-alt](r_tpi.png)

## REFERENCES

Guisan, A., S. B. Weiss, A. D. Weiss 1999. GLM versus CCA spatial
modeling of plant species distribution. Plant Ecology 143: 107-122

## SEE ALSO

*[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html),*

## AUTHOR

Steven Pawley

## SOURCE CODE

Available at: [r.tpi source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.tpi)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.tpi))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
