---
name: r.univar2
description: Calculates univariate statistics from the non-null cells of a raster map.
keywords: [ raster, statistics, univariate statistics, zonal statistics ]
---

# r.univar2

Calculates univariate statistics from the non-null cells of a raster map.

=== "Command line"

    **r.univar2**
    [**-get**]
    **map**=*name* [,*name*,...]
    [**zones**=*name*]
    [**output**=*name*]
    [**percentile**=*float* [,*float*,...]]
    [**tolerance**=*float*]
    [**separator**=*character*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.univar2 map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.univar2***",
        **map**,
        **zones**=*None*,
        **output**=*None*,
        **percentile**=*90*,
        **tolerance**=*0.5*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.univar2", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_univar2*(**map**,
        **zones**=*None*,
        **output**=*None*,
        **percentile**=*90*,
        **tolerance**=*0.5*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_univar2(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s)  
    **zones**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map used for zoning, must be of type CELL  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    **percentile**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (requires extended statistics flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **tolerance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance to consider float number equal to another when computing the mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print the stats in shell script style  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Calculate extended statistics  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Table output format instead of standard output format  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **zones** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map used for zoning, must be of type CELL  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **percentile** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (requires extended statistics flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance to consider float number equal to another when computing the mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *e*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the stats in shell script style  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate extended statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Table output format instead of standard output format  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **zones** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map used for zoning, must be of type CELL  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **percentile** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (requires extended statistics flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance to consider float number equal to another when computing the mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *e*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the stats in shell script style  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate extended statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Table output format instead of standard output format  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.univar* calculates the univariate statistics of one or several raster
map(s). This includes the number of cells counted, minimum and maximum
cell values, range, arithmetic mean, population variance, standard
deviation, and coefficient of variation. Statistics are calculated
separately for every category/zone found in the **zones** input map if
given. If the **-e** extended statistics flag is given the 1st quartile,
median, 3rd quartile, and given **percentile** are calculated. If the
**-g** flag is given the results are presented in a format suitable for
use in a shell script. If the **-t** flag is given the results are
presented in tabular format with the given field separator. The table
can immediately be converted to a vector attribute table which can then
be linked to a vector, e.g. the vector that was rasterized to create the
**zones** input raster.

When multiple input maps are given to *r.univar*, the overall statistics
are calculated. This is useful for a time series of the same variable,
as well as for the case of a segmented/tiled dataset. Allowing multiple
raster maps to be specified saves the user from using a temporary raster
map for the result of *r.series* or *r.patch*.

## NOTES

As with most GRASS raster modules, *r.univar* operates on the raster
array defined by the current region settings, not the original extent
and resolution of the input map. See
*[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html)*.

This module can use large amounts of system memory when the **-e**
extended statistics flag is used with a very large region setting. If
the region is too large the module should exit gracefully with a memory
allocation error. Basic statistics can be calculated using any size
input region.

Without a **zones** input raster, the *r.quantile* module will be
significantly more efficient for calculating percentiles with large
maps.

## EXAMPLE

Calculate the raster statistics for zones within a vector map coverage
and upload the results for mean, min and max back to the vector map:

```sh
#### set the raster region to match the map
g.region vector=fields res=10 -ap

#### create rasterized version of vector map
v.to.rast in=fields out=fields.10m use=cat type=area labelcolumn=label
r.colors fields.10m color=random

#### perform analysis
r.univar -t map=elevation.10m zones=fields.10m | \
  cut -f1,5,6,8 -d'|' > fields_stats.txt


#### populate vector DB with stats

# create working copy of vector map
g.copy vector=fields,fields_stats

# create new attribute columns to hold output
v.db.addcol map=fields_stats \
  columns='mean_elev DOUBLE PRECISION, min_elev DOUBLE PRECISION, max_elev DOUBLE PRECISION'

# create SQL command file, and execute it
sed -e '1d' fields_stats.txt | awk -F'|' \
  '{print "UPDATE fields_stats SET min_elev = "$2", max_elev = "$3", \
  mean_elev = "$4" WHERE cat = "$1";"}' \
   > fields_stats_sqlcmd.txt

db.execute input=fields_stats_sqlcmd.txt


#### view completed table
v.db.select fields_stats
```

## SEE ALSO

*[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html),
[r3.univar](https://grass.osgeo.org/grass-stable/manuals/r3.univar.html),
[r.mode](https://grass.osgeo.org/grass-stable/manuals/r.mode.html),
[r.quantile](https://grass.osgeo.org/grass-stable/manuals/r.quantile.html),
[r.series](https://grass.osgeo.org/grass-stable/manuals/r.series.html),
[r.stats](https://grass.osgeo.org/grass-stable/manuals/r.stats.html),
[r.statistics](https://grass.osgeo.org/grass-stable/manuals/r.statistics.html),
[v.rast.stats](https://grass.osgeo.org/grass-stable/manuals/v.rast.stats.html),
[v.univar](https://grass.osgeo.org/grass-stable/manuals/v.univar.html)*

## AUTHORS

Hamish Bowman, Otago University, New Zealand  
Extended statistics by Martin Landa  
Multiple input map support by Ivan Shmakov  
Zonal loop by Markus Metz

## SOURCE CODE

Available at: [r.univar2 source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.univar2)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.univar2))  
Latest change: Thursday Feb 20 20:36:19 2025 in commit [158e314](https://github.com/OSGeo/grass-addons/commit/158e314c788f983e3a448ec1b1ba3f226b5ca3e9)
