---
name: r3.count.categories.py
description: Count categories in vertical direction
keywords: [ raster3d, conversion, raster, category, voxel ]
---

# r3.count.categories.py

Count categories in vertical direction

=== "Command line"

    **r3.count.categories.py**
    [**-ds**]
    **input**=*name*
    **output**=*basename*
    **slices**=*basename*
    [**multiply**=*float*]
    [**add**=*float*]
    [**size**=*integer*]
    [**surface**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.count.categories.py input=name output=basename slices=basename
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.count.categories.py***",
        **input**,
        **output**,
        **slices**,
        **multiply**=*None*,
        **add**=*None*,
        **size**=*None*,
        **surface**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.count.categories.py", input="name", output="basename", slices="basename")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_count_categories_py*(**input**,
        **output**,
        **slices**,
        **multiply**=*None*,
        **add**=*None*,
        **size**=*None*,
        **surface**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_count_categories_py(input="name", output="basename", slices="basename")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    **output**=*basename* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    **slices**=*basename* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for horizontal slices of the 3D raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    **multiply**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to multiply the raster values with  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient a in the equation y = ax + b  
    **add**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to add to the raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient b in the equation y = ax + b  
    **size**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Moving window size  
    &nbsp;&nbsp;&nbsp;&nbsp;By default, only the given cell is considered  
    **surface**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Count only those cells which are under the surface (in cells)  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Divide count by the number of cells in the surface  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Expect the slices to be already present  
    &nbsp;&nbsp;&nbsp;&nbsp;When running the module over and over, this saves the slicing 3D raster step  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **slices** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for horizontal slices of the 3D raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **multiply** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to multiply the raster values with  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient a in the equation y = ax + b  
    **add** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to add to the raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient b in the equation y = ax + b  
    **size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Moving window size  
    &nbsp;&nbsp;&nbsp;&nbsp;By default, only the given cell is considered  
    **surface** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Count only those cells which are under the surface (in cells)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Divide count by the number of cells in the surface  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Expect the slices to be already present  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;When running the module over and over, this saves the slicing 3D raster step  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **slices** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for horizontal slices of the 3D raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **multiply** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to multiply the raster values with  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient a in the equation y = ax + b  
    **add** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to add to the raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient b in the equation y = ax + b  
    **size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Moving window size  
    &nbsp;&nbsp;&nbsp;&nbsp;By default, only the given cell is considered  
    **surface** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Count only those cells which are under the surface (in cells)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Divide count by the number of cells in the surface  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Expect the slices to be already present  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;When running the module over and over, this saves the slicing 3D raster step  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r3.count.categories* iterates over whole numbers (categories, classes)
in the 3D raster (considers values to be integers) and for each vertical
column counts them in the given column.

The 3D raster map is considered to be integer, i.e. all values are
converted to integer values with truncation. When some conversion is
appropriate the **multiply** option can be used to scale the value
before conversion. For example, if the values are percentages with
values between 0 and 1, value 100 can be used to obtain percentages
between 0 and 100. The values will be then preserved with precision 1
(decimal part is truncated).

## SEE ALSO

*[r3.to.rast](https://grass.osgeo.org/grass-stable/manuals/r3.to.rast.html),
[r3.to.group](r3.to.group.md) (addon),
[r3.what](https://grass.osgeo.org/grass-stable/manuals/r3.what.html)*

## AUTHOR

Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r3.count.categories source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster3d/r3.count.categories)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster3d/r3.count.categories))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
