---
name: r3.out.ascii
description: Converts a 3D raster map layer into a ASCII text file.
keywords: [ raster3d, export, output, voxel, conversion, ASCII ]
---

# r3.out.ascii

Converts a 3D raster map layer into a ASCII text file.

=== "Command line"

    **r3.out.ascii**
    [**-hrdcm**]
    **input**=*string*
    [**output**=*name*]
    [**precision**=*integer*]
    [**null_value**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.out.ascii input=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.out.ascii***",
        **input**,
        **output**=*None*,
        **precision**=*8*,
        **null_value**=*"\*"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.out.ascii", input="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_out_ascii*(**input**,
        **output**=*None*,
        **precision**=*8*,
        **null_value**=*"\*"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_out_ascii(input="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map to be converted to ASCII  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for ASCII output file  
    **precision**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of decimal places for floats  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-20*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **null_value**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of header information  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Switch the row order in output from north-&gt;south to south-&gt;north  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Switch the depth order in output from bottom-&gt;top to top-&gt;bottom  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print grass6 compatible format. Flags -d and -r are ignored.  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with input map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map to be converted to ASCII  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3d-raster  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for ASCII output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **precision** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of decimal places for floats  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-20*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *h*, *r*, *d*, *c*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of header information  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switch the row order in output from north-&gt;south to south-&gt;north  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switch the depth order in output from bottom-&gt;top to top-&gt;bottom  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print grass6 compatible format. Flags -d and -r are ignored.  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with input map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map to be converted to ASCII  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3d-raster  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for ASCII output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **precision** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of decimal places for floats  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-20*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *h*, *r*, *d*, *c*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of header information  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switch the row order in output from north-&gt;south to south-&gt;north  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switch the depth order in output from bottom-&gt;top to top-&gt;bottom  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print grass6 compatible format. Flags -d and -r are ignored.  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with input map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r3.out.ascii* exports a 3D raster map in ASCII format. The *input*
parameter is a valid 3D raster map in the current mapset search path.
The *output* parameter is the name of an ASCII file which will be
written in the current working directory.

If *output* is not specified then standard output (stdout) is used. The
*-h* flag may be used to suppress header information. The module is
sensitive to region settings (set with *g.region*).

The *-c* flag will create GRASS 6 *r3.in.ascii* compatible output.

## NOTES

The default format of the exported ASCII file is equivalent to that
required by *r3.in.ascii*. In particular, files output by *r3.out.ascii*
with header information may be converted back to 3D raster maps with
*r3.in.ascii*.

The format of the ASCII file is:

```sh
version: "grass7"
order:   "nsbt" or "nstb" or "snbt" or "sntb"
north:   floating point
south:   floating point
east:    floating point
west:    floating point
top:     floating point
bottom:  floating point
rows:    integer
cols:    integer
levels:  integer
```

The **version** and **order** options have been introduced in GRASS 7 in
June 2011. The **order** option describes the order of rows and depths
in the output. It is possible to create output of different row order
using the *-r* flag and output of different depths order using the *-d*
flag. The default order is:

```sh
west -> east for columns
north -> south for rows
bottom -> top for depths
```

This header is followed by the cell values in *floating point* format
organized in rows with constant *col* and *level* coordinate. The rows
are organized by constant *level* coordinate. Individual cell values are
separated by *space* or *CR*. Cell values are exported as a series of
horizontal slices in row-major order. The data starts with the upper
left corner (NW) at the bottom of the data set. The values at the
following coordinates are exported:

```sh
(x, y + rows,     z) (x + 1, y + rows,     z) ... (x + cols, y + rows,     z)
(x, y + rows,     z) (x + 1, y + rows - 1, z) ... (x + cols, y + rows - 1, z)
          .                     .                                .
          .                     .                                .
          .                     .                                .
(x, y,   z + depths) (x + 1, y,   z + depths) ... (x + cols, y,   z + depths)
```

This order is compatible with the *r.in.ascii* row -\> column ordering.

Supported orders are:

- **nsbt**: north -\> south and bottom -\> top ordering which is the
  default (no flags)
- **snbt**: south -\> north and bottom -\> top ordering using *-r* flag
- **nstb**: north -\> south and top -\> bottom ordering using *-d* flag
- **sntb**: south -\> north and top -\> bottom ordering using *-rd* flag

The internal storage scheme of 3D raster maps is visualized in the
following picture:

![The coordinate system and tile layout](raster3d_layout.png)  
*The coordinate system and tile layout of a voxel map in GRASS*

One level maps can be imported with *r.in.ascii* (2D raster) using the
default **nsbt** order and removing the header lines "version", "order",
"top", "bottom" and "levels".

## EXAMPLES

We define a small region with 4 columns, 3 rows and 2 depths (4x3x2) and
export it using different ordering definitions:

```sh
g.region res3=1 t=2 b=0 w=0 e=4 s=0 n=3
r3.mapcalc "simple_example = row() + col() + depth()"
```

Default order:

```sh
r3.out.ascii input=simple_example dp=0

version: grass7
order: nsbt
north: 3.000000
south: 0.000000
east: 4.000000
west: 0.000000
top: 2.000000
bottom: 0.000000
rows: 3
cols: 4
levels: 2
3 4 5 6
4 5 6 7
5 6 7 8
4 5 6 7
5 6 7 8
6 7 8 9
```

Inverse row order (-r)

```sh
r3.out.ascii input=simple_example dp=0 -r

version: grass7
order: snbt
north: 3.000000
south: 0.000000
east: 4.000000
west: 0.000000
top: 2.000000
bottom: 0.000000
rows: 3
cols: 4
levels: 2
5 6 7 8
4 5 6 7
3 4 5 6
6 7 8 9
5 6 7 8
4 5 6 7
```

Inverse depth order (-d)

```sh
r3.out.ascii input=simple_example dp=0 -d
version: grass7
order: nstb
north: 3.000000
south: 0.000000
east: 4.000000
west: 0.000000
top: 2.000000
bottom: 0.000000
rows: 3
cols: 4
levels: 2
4 5 6 7
5 6 7 8
6 7 8 9
3 4 5 6
4 5 6 7
5 6 7 8
```

Inverse row and depth order (-rd)

```sh
r3.out.ascii input=simple_example dp=0 -rd

version: grass7
order: sntb
north: 3.000000
south: 0.000000
east: 4.000000
west: 0.000000
top: 2.000000
bottom: 0.000000
rows: 3
cols: 4
levels: 2
6 7 8 9
5 6 7 8
4 5 6 7
5 6 7 8
4 5 6 7
3 4 5 6
```

## SEE ALSO

*[r3.in.ascii](r3.in.ascii.md), [r.out.ascii](r.out.ascii.md),
[g.region](g.region.md)*

## AUTHORS

Roman Waupotitsch, Michael Shapiro, Helena Mitasova, Bill Brown, Lubos
Mitas, Jaro Hofierka, Sören Gebbert

## SOURCE CODE

Available at: [r3.out.ascii source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.out.ascii)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.out.ascii))  
Latest change: Wednesday Oct 01 19:33:56 2025 in commit [2bff9b5](https://github.com/OSGeo/grass/commit/2bff9b53785aeeed0248becad0089c3a0ec05479)
