---
name: r3.profile
description: Outputs the raster map layer values lying on user-defined line(s).
keywords: [ raster, profile ]
---

# r3.profile

Outputs the raster map layer values lying on user-defined line(s).

=== "Command line"

    **r3.profile**
    [**-gc**]
    **input**=*name*
    [**output**=*name*]
    [**raster_output**=*name*]
    [**coordinates**=*east,north* [,*east,north*,...]]
    [**file**=*name*]
    [**resolution**=*float*]
    [**null_value**=*string*]
    [**units**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.profile input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.profile***",
        **input**,
        **output**=*"-"*,
        **raster_output**=*None*,
        **coordinates**=*None*,
        **file**=*None*,
        **resolution**=*None*,
        **null_value**=*"\*"*,
        **units**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.profile", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_profile*(**input**,
        **output**=*"-"*,
        **raster_output**=*None*,
        **coordinates**=*None*,
        **file**=*None*,
        **resolution**=*None*,
        **null_value**=*"\*"*,
        **units**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_profile(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file for output (use output=- for stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **raster_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **coordinates**=*east,north* [,*east,north*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Profile coordinate pairs  
    **file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file containing coordinate pairs  
    &nbsp;&nbsp;&nbsp;&nbsp;Use instead of the 'coordinates' option. "-" reads from stdin.  
    **resolution**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution along profile (default = current region resolution)  
    **null_value**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **units**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;If units are not specified, current location units are used. Meters are used by default in geographic (latlon) locations.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *meters, kilometers, feet, miles*  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output easting and northing in first two columns of four column output  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output RRR:GGG:BBB color values for each profile point  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file for output (use output=- for stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **raster_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Profile coordinate pairs  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file containing coordinate pairs  
    &nbsp;&nbsp;&nbsp;&nbsp;Use instead of the 'coordinates' option. "-" reads from stdin.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **resolution** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution along profile (default = current region resolution)  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;If units are not specified, current location units are used. Meters are used by default in geographic (latlon) locations.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *meters, kilometers, feet, miles*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output easting and northing in first two columns of four column output  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output RRR:GGG:BBB color values for each profile point  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file for output (use output=- for stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **raster_output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Profile coordinate pairs  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **file** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file containing coordinate pairs  
    &nbsp;&nbsp;&nbsp;&nbsp;Use instead of the 'coordinates' option. "-" reads from stdin.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **resolution** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution along profile (default = current region resolution)  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;If units are not specified, current location units are used. Meters are used by default in geographic (latlon) locations.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *meters, kilometers, feet, miles*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output easting and northing in first two columns of four column output  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output RRR:GGG:BBB color values for each profile point  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

This program outputs two or four column (with **-g**) data to stdout or
an ASCII file. The default two column output consists of cumulative
profile length and raster value. The optional four column output
consists of easting, northing, cumulative profile length, and raster
value. Profile end or "turning" points can be set manually with the
**coordinates** argument. The profile resolution, or distance between
profile points, is obtained from the current region resolution, or can
be manually set with the **resolution** argument.

The **coordinates** parameter can be set to comma separated geographic
coordinates for profile line endpoints. Alternatively the coordinate
pairs can be piped from the text file specified by **file** option, or
if set to "-", from `stdin`. In these cases the coordinate pairs should
be given one comma separated pair per line.

The **resolution** parameter sets the distance between each profile
point (resolution). The resolution must be provided in GRASS database
units (i.e. decimal degrees for Lat Long databases and meters for UTM).
By default *r.profile* uses the resolution of the current GRASS region.

The **null** parameter can optionally be set to change the character
string representing null values.

## OUTPUT FORMAT

The multi column output from *r.profile* is intended for easy use in
other programs. The output can be piped (|) directly into other programs
or saved to a file for later use. Output with geographic coordinates
(*-g*) is compatible with
*[v.in.ascii](https://grass.osgeo.org/grass-stable/manuals/v.in.ascii.html)*
and can be piped direcly into this program.

```sh
r.profile -g input=elevation coordinates=... | v.in.ascii output=elevation_profile separator=space
```

The 2 column output is compatible with most plotting programs.

The optional RGB output provides the associated GRASS colour value for
each profile point.

Option **units** enables to set units of the profile length output. If
the units are not specified, current location units will be used. In
case of geographic locations (latitude/longitude), meters are used as
default unit.

## NOTES

The profile resolution is measured exactly from the supplied end or
"turning" point along the profile. The end of a profile segment will be
an exact multiple of the profile resolution and will therefore not
always match the end point coordinates entered for the segmanet.

To extract the numbers in scripts, following parameters can be used:

```sh
r.profile input=dgm12.5 coordinates=3570631,5763556 2>/dev/null
```

This filters out the everything except the numbers.

## EXAMPLES

### Extraction of values along profile defined by coordinates (variant 1)

Extract a profile with coordinates (wayoints) provided on the command
line (North Carolina data set):

```sh
g.region raster=elevation -p
r.profile -g input=elevation output=profile_points.csv \
          coordinates=641712,226095,641546,224138,641546,222048,641049,221186
```

This will extract a profile along the track defined by the three
coordinate pairs. The output file "profile\_points.csv" contains
east,north,distance,value (here: elevation).

### Extraction of values along profile defined by coordinates (variant 2)

Coordinate pairs can also being "piped" into *r.profile* (variant 2a):

```sh
r.profile elevation resolution=1000 file=- << EOF
641712,226095
641546,224138
641546,222048
641049,221186
EOF
```

Coordinate pairs can also being "piped" into *r.profile* (variant 2b):

```sh
echo "641712,226095
641546,224138
641546,222048
641049,221186" > coors.txt
cat coors.txt | r.profile elevation resolution=1000 file=-
```

The output is printed into the terminal (unless the *output* parameter
is used) and looks as follows:

```text
Using resolution: 1000 [meters]
Output columns:
Along track dist. [meters], Elevation
Approx. transect length: 1964.027749 [meters]
 0.000000 84.661507
 1000.000000 98.179062
Approx. transect length: 2090.000000 [meters]
 1964.027749 83.638138
 2964.027749 89.141029
 3964.027749 78.497757
Approx. transect length: 995.014070 [meters]
 4054.027749 73.988029
```

## SEE ALSO

*[v.in.ascii](https://grass.osgeo.org/grass-stable/manuals/v.in.ascii.html),
[r.what](https://grass.osgeo.org/grass-stable/manuals/r.what.html),
[r.transect](https://grass.osgeo.org/grass-stable/manuals/r.transect.html),
[wxGUI profile
tool](https://grass.osgeo.org/grass-stable/manuals/wxGUI.html)*

## AUTHOR

[Bob Covill](mailto:bcovill@tekmap.ns.ca)

## SOURCE CODE

Available at: [r3.profile source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster3d/r3.profile)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster3d/r3.profile))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
