---
name: t.rast.null.py
description: Manages NULL-values of a given space time raster dataset.
keywords: [ temporal, raster, null data, parallel ]
---

# t.rast.null.py

Manages NULL-values of a given space time raster dataset.

=== "Command line"

    **t.rast.null.py**
    **input**=*name*
    [**setnull**=*string* [,*string*,...]]
    [**null**=*float*]
    [**where**=*sql_query*]
    [**nprocs**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast.null.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.rast.null.py***",
        **input**,
        **setnull**=*None*,
        **null**=*None*,
        **where**=*None*,
        **nprocs**=*1*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.rast.null.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast_null_py*(**input**,
        **setnull**=*None*,
        **null**=*None*,
        **where**=*None*,
        **nprocs**=*1*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast_null_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    **setnull**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be set to NULL  
    **null**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to replace the null value by  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.null processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **setnull** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be set to NULL  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to replace the null value by  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.null processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **setnull** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be set to NULL  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to replace the null value by  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.null processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

***t.rast.null*** manages NULL-values of the input space time raster
dataset.

The **setnull** parameter is used to specify values in the ranges to be
set to NULL. A range is either a single value (e.g., 5.3), or a pair of
values (e.g., 4.76-34.56). Existing NULL-values are left NULL, unless
the null argument is requested.

The **null** parameter eliminates the NULL value and replaces it with
the given value. This argument is applied only to existing NULL values,
and not to the NULLs created by the **setnull** argument.

## EXAMPLES

Set specific values (0,-1 and -2) of a space time raster dataset to
NULL:

```sh
    t.rast.null input=MY_INPUT_DATASET setnull=0,-1,-2
```

## SEE ALSO

*[r.null](https://grass.osgeo.org/grass-stable/manuals/r.null.html)*

## AUTHOR

Luca Delucchi, Fondazione Edmund Mach

## SOURCE CODE

Available at: [t.rast.null source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/temporal/t.rast.null)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/temporal/t.rast.null))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
