---
name: t.rast.patch.py
description: Patches multiple space time raster maps into a single raster map using r.patch.
keywords: [ temporal, aggregation, series, raster, merge, patching, time ]
---

# t.rast.patch.py

Patches multiple space time raster maps into a single raster map using r.patch.

=== "Command line"

    **t.rast.patch.py**
    [**-tzsv**]
    **input**=*name*
    [**where**=*sql_query*]
    **output**=*name*
    [**sort**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast.patch.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.rast.patch.py***",
        **input**,
        **where**=*None*,
        **output**,
        **sort**=*"desc"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.rast.patch.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast_patch_py*(**input**,
        **where**=*None*,
        **output**,
        **sort**=*"desc"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast_patch_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **sort**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort order (see sort parameter)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *asc, desc*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *desc*  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not assign the space time raster dataset start and end time to the output map  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use zero (0) for transparency instead of NULL  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not create color and category files  
    **-v**  
    &nbsp;&nbsp;&nbsp;&nbsp;Patch to virtual raster map (r.buildvrt)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **sort** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort order (see sort parameter)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *asc, desc*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *desc*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *z*, *s*, *v*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not assign the space time raster dataset start and end time to the output map  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use zero (0) for transparency instead of NULL  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create color and category files  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Patch to virtual raster map (r.buildvrt)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **sort** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort order (see sort parameter)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *asc, desc*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *desc*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *z*, *s*, *v*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not assign the space time raster dataset start and end time to the output map  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use zero (0) for transparency instead of NULL  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create color and category files  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Patch to virtual raster map (r.buildvrt)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

This module patches raster maps that have gaps in time with subsequent
maps (within a space time raster dataset) using *r.patch* or
**r.buildvrt**. Hence it is a wrapper for those two modules in the
temporal domain.

By default *r.patch* is used to create a patched raster map. Especially
for temporary data, using **r.buildvrt** for patching can be
advantageous with regards to processing time and storage space.
**r.buildvrt** creates a virtual raser map and is used when the
**v-flag** is given. The **v-flag** excludes the **z-flag** (using zero
(0) for transperancy) and **s-flag (do not create color and category
files)**.

The input of this module is a single space time raster dataset, the
output is a single raster map layer. A subset of the input space time
raster dataset can be selected using the **where** option. The sorting
of the raster map layer can be set using the **sort** option. Be aware
that the sorting of the maps significantly influences the result of the
patch. By default the maps are sorted by **desc** by the *start\_time*
so that the newest raster map is the first input map in
**r.patch**/**r.buildvrt**.

Please note that the color table of the first input raster is used for
the resulting map when the **v-flag** is used. Values in the resulting
raster map that exeed the range of that first raster map will then be
rendered on the screen like no data. In that case, please update the
color table or the resulting map with **r.colors**

*t.rast.patch* is a simple wrapper for the raster module **r.patch** or
**r.buildvrt**.

## EXAMPLE

The example uses the North Carolina extra time series of MODIS Land
Surface Temperature maps
([download](https://grass.osgeo.org/download/data/)). (The mapset has to
be unzip in one of the North Carolina locations.)

Patching the MODIS Land Surface Temperature for 2016 (filling missing
pixels by subsequent maps in the time series):

```sh
t.rast.patch input=LST_Day_monthly@modis_lst output=LST_Day_patched_2016 \
  where="start_time >= '2016-01' and start_time <= '2016-12'"
r.info LST_Day_patched_2016
```

Patching the MODIS Land Surface Temperature for 2016 (filling missing
pixels by subsequent maps in the time series) using a virtual mosaic
(**r.buildvrt**):

```sh
t.rast.patch -v input=LST_Day_monthly@modis_lst output=LST_Day_patched_2016_vrt \
  where="start_time >= '2016-01' and start_time <= '2016-12'"
# Assign a new color table that covers the entire range of the resulting map
r.colors map=LST_Day_patched_2016_vrt color=grey
r.info LST_Day_patched_2016_vrt
```

## SEE ALSO

*[r.buildvrt](https://grass.osgeo.org/grass-stable/manuals/r.buildvrt.html),
[r.patch](https://grass.osgeo.org/grass-stable/manuals/r.patch.html),
[t.rast.series](https://grass.osgeo.org/grass-stable/manuals/t.rast.series.html),
[t.create](https://grass.osgeo.org/grass-stable/manuals/t.create.html),
[t.info](https://grass.osgeo.org/grass-stable/manuals/t.info.html),
[t.merge](https://grass.osgeo.org/grass-stable/manuals/t.merge.html)*

[Temporal data processing
Wiki](https://grasswiki.osgeo.org/wiki/Temporal_data_processing)

## AUTHOR

Anika Bettge, mundialis GmbH & Co. KG

## SOURCE CODE

Available at: [t.rast.patch source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/temporal/t.rast.patch)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/temporal/t.rast.patch))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
