---
name: t.stac.item.py
description: Downloads and imports data from a STAC API server.
keywords: [ raster, import, STAC, temporal ]
---

# t.stac.item.py

Downloads and imports data from a STAC API server.

=== "Command line"

    **t.stac.item.py**
    [**-miadp**]
    **url**=*string*
    **collection_id**=*string*
    [**request_method**=*string*]
    [**settings**=*name*]
    [**max_items**=*integer*]
    [**limit**=*integer*]
    [**ids**=*string*]
    [**bbox**=*float* [,*float*,...]]
    [**intersects**=*name*]
    [**datetime**=*string*]
    [**query**=*string*]
    [**filter**=*string*]
    [**asset_keys**=*string* [,*string*,...]]
    [**item_roles**=*string* [,*string*,...]]
    [**filter_lang**=*string*]
    [**sortby**=*string*]
    [**format**=*string*]
    [**strds_output**=*name*]
    [**items_vector**=*string*]
    [**method**=*string*]
    [**resolution**=*string*]
    [**resolution_value**=*float*]
    [**extent**=*string*]
    [**nprocs**=*integer*]
    [**memory**=*memory in MB*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.stac.item.py url=string collection_id=string
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***t.stac.item.py***",
        **url**,
        **collection_id**,
        **request_method**=*"POST"*,
        **settings**=*None*,
        **max_items**=*1000*,
        **limit**=*100*,
        **ids**=*None*,
        **bbox**=*None*,
        **intersects**=*None*,
        **datetime**=*None*,
        **query**=*None*,
        **filter**=*None*,
        **asset_keys**=*None*,
        **item_roles**=*None*,
        **filter_lang**=*None*,
        **sortby**=*None*,
        **format**=*"json"*,
        **strds_output**=*None*,
        **items_vector**=*None*,
        **method**=*"nearest"*,
        **resolution**=*"estimated"*,
        **resolution_value**=*None*,
        **extent**=*"input"*,
        **nprocs**=*0*,
        **memory**=*300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("t.stac.item.py", url="string", collection_id="string", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_stac_item_py*(**url**,
        **collection_id**,
        **request_method**=*"POST"*,
        **settings**=*None*,
        **max_items**=*1000*,
        **limit**=*100*,
        **ids**=*None*,
        **bbox**=*None*,
        **intersects**=*None*,
        **datetime**=*None*,
        **query**=*None*,
        **filter**=*None*,
        **asset_keys**=*None*,
        **item_roles**=*None*,
        **filter_lang**=*None*,
        **sortby**=*None*,
        **format**=*"json"*,
        **strds_output**=*None*,
        **items_vector**=*None*,
        **method**=*"nearest"*,
        **resolution**=*"estimated"*,
        **resolution_value**=*None*,
        **extent**=*"input"*,
        **nprocs**=*0*,
        **memory**=*300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_stac_item_py(url="string", collection_id="string", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **url**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;STAC API Client URL  
    **collection_id**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Collection Id.  
    **request_method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;The HTTP method to use when making a request to the service.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *GET, POST*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *POST*  
    **settings**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    **max_items**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum number of items to return from the search, even if there are more matching results.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **limit**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;A recommendation to the service as to the number of items to return per page of results. Defaults to 100.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **ids**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of one or more Item ids to filter on.  
    **bbox**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;The bounding box of the request in WGS84 (example [-72.5,40.5,-72,41]). (default is current region)  
    **intersects**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Results filtered to only those intersecting the geometry.  
    **datetime**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Datetime Filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a single datetime or datetime range used to filter results.  
    **query**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;List or JSON of query parameters as per the STAC API query extension.  
    **filter**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;JSON of query parameters as per the STAC API filter extension  
    **asset_keys**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Asset Keys  
    &nbsp;&nbsp;&nbsp;&nbsp;List of one or more asset keys to filter item downloads.  
    **item_roles**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Item roles  
    &nbsp;&nbsp;&nbsp;&nbsp;List of one or more item roles to filter by.  
    **filter_lang**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Language variant used in the filter body. If filter is a dictionary or not provided, defaults to cql2-json. If filter is a string, defaults to cql2-text.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cql2-json, cql2-text*  
    **sortby**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single field or list of fields to sort the response by  
    **format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *json, plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *json*  
    **strds_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;STRDS Output  
    &nbsp;&nbsp;&nbsp;&nbsp;Spatial Temporal Raster Dataset Registration File  
    **items_vector**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector containing STAC item boundaries and metadata.  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection (required if location projection not longlat)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    **resolution**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (default: estimated)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *estimated, value, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *estimated*  
    &nbsp;&nbsp;&nbsp;&nbsp;**estimated**: estimated resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**value**:  user-specified resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: current region resolution  
    **resolution_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (use with option resolution=value)  
    **extent**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map extent  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: extent of input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**:  extent of current region  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **memory**=*memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Collection Search Item Summary  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Item metadata  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Asset metadata  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Dowload and import assets  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Pretty print the JSON output  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;STAC API Client URL  
    **collection_id** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Collection Id.  
    **request_method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The HTTP method to use when making a request to the service.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *GET, POST*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *POST*  
    **settings** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **max_items** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum number of items to return from the search, even if there are more matching results.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **limit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;A recommendation to the service as to the number of items to return per page of results. Defaults to 100.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **ids** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of one or more Item ids to filter on.  
    **bbox** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The bounding box of the request in WGS84 (example [-72.5,40.5,-72,41]). (default is current region)  
    **intersects** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Results filtered to only those intersecting the geometry.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **datetime** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Datetime Filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a single datetime or datetime range used to filter results.  
    **query** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List or JSON of query parameters as per the STAC API query extension.  
    **filter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;JSON of query parameters as per the STAC API filter extension  
    **asset_keys** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Asset Keys  
    &nbsp;&nbsp;&nbsp;&nbsp;List of one or more asset keys to filter item downloads.  
    **item_roles** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Item roles  
    &nbsp;&nbsp;&nbsp;&nbsp;List of one or more item roles to filter by.  
    **filter_lang** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Language variant used in the filter body. If filter is a dictionary or not provided, defaults to cql2-json. If filter is a string, defaults to cql2-text.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cql2-json, cql2-text*  
    **sortby** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single field or list of fields to sort the response by  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *json, plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *json*  
    **strds_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;STRDS Output  
    &nbsp;&nbsp;&nbsp;&nbsp;Spatial Temporal Raster Dataset Registration File  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **items_vector** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector containing STAC item boundaries and metadata.  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection (required if location projection not longlat)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **resolution** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (default: estimated)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *estimated, value, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;**estimated**: estimated resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**value**:  user-specified resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: current region resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *estimated*  
    **resolution_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (use with option resolution=value)  
    **extent** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map extent  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: extent of input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**:  extent of current region  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *i*, *a*, *d*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Collection Search Item Summary  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Item metadata  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Asset metadata  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dowload and import assets  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pretty print the JSON output  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;STAC API Client URL  
    **collection_id** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Collection Id.  
    **request_method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The HTTP method to use when making a request to the service.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *GET, POST*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *POST*  
    **settings** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **max_items** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum number of items to return from the search, even if there are more matching results.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **limit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;A recommendation to the service as to the number of items to return per page of results. Defaults to 100.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **ids** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of one or more Item ids to filter on.  
    **bbox** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The bounding box of the request in WGS84 (example [-72.5,40.5,-72,41]). (default is current region)  
    **intersects** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Results filtered to only those intersecting the geometry.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **datetime** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Datetime Filter  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a single datetime or datetime range used to filter results.  
    **query** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List or JSON of query parameters as per the STAC API query extension.  
    **filter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;JSON of query parameters as per the STAC API filter extension  
    **asset_keys** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Asset Keys  
    &nbsp;&nbsp;&nbsp;&nbsp;List of one or more asset keys to filter item downloads.  
    **item_roles** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Item roles  
    &nbsp;&nbsp;&nbsp;&nbsp;List of one or more item roles to filter by.  
    **filter_lang** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Language variant used in the filter body. If filter is a dictionary or not provided, defaults to cql2-json. If filter is a string, defaults to cql2-text.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cql2-json, cql2-text*  
    **sortby** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single field or list of fields to sort the response by  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *json, plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *json*  
    **strds_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;STRDS Output  
    &nbsp;&nbsp;&nbsp;&nbsp;Spatial Temporal Raster Dataset Registration File  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **items_vector** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector containing STAC item boundaries and metadata.  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection (required if location projection not longlat)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **resolution** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (default: estimated)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *estimated, value, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;**estimated**: estimated resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**value**:  user-specified resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: current region resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *estimated*  
    **resolution_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map (use with option resolution=value)  
    **extent** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map extent  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: extent of input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**:  extent of current region  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *i*, *a*, *d*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Collection Search Item Summary  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Item metadata  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Asset metadata  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dowload and import assets  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pretty print the JSON output  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.stac.item* is a tool for exploring and importing SpatioTemporal Asset
Catalog item metadata and assets into GRASS GIS. The tool is based on
the [PySTAC\_Client
(0.8)](https://pystac-client.readthedocs.io/en/stable/) library and
allows you to search items in a STAC Catalog. The search can be done by
specifying the item ID, collection ID, datatime or by using a search
query. The full list of search parameters and documentation can be found
at [PySTAC\_Client
ItemSearch](https://pystac-client.readthedocs.io/en/stable/api.html#item-search).

## NOTES

The *t.stac.item* tool is part of the
[t.stac](https://grass.osgeo.org/grass-stable/manuals/t.stac.html)
temporal data processing framework. The tool requries that the data
provider has implement the STAC API and conforms to *Item Search*
specification.

## REQUIREMENTS

- [PySTAC
    (1.10.x)](https://pystac.readthedocs.io/en/stable/installation.html)
- [PySTAC\_Client
    (0.8)](https://pystac-client.readthedocs.io/en/stable/)
- tqdm (4.66.x)
- numpy (1.26.x)

## EXAMPLES

### Get the item metadata from a STAC API

```sh
    t.stac.catalog url="https://earth-search.aws.element84.com/v1/"
    t.stac.collection url="https://earth-search.aws.element84.com/v1/" collection_id="sentinel-2-l2a"
    t.stac.item -i url="https://earth-search.aws.element84.com/v1/" collection_id="sentinel-2-l2a" item_id="S2B_36QWD_20220301_0_L2A"
```

### Get the asset metadata from a STAC API

```sh
    t.stac.catalog url="https://earth-search.aws.element84.com/v1/"
    t.stac.collection url="https://earth-search.aws.element84.com/v1/" collection_id="sentinel-2-l2a"
    t.stac.item -a url="https://earth-search.aws.element84.com/v1/" collection_id="sentinel-2-l2a" item_id="S2B_36QWD_20220301_0_L2A"
```

### Use datetime filter

```sh
    t.stac.item url="https://earth-search.aws.element84.com/v1/" collection_id="sentinel-2-l2a" datetime=2017-06-10/2017-06-11
```

### Use query option

```sh
    t.stac.item url="https://earth-search.aws.element84.com/v1/" collection_id="sentinel-2-l2a" query='{"eo:cloud_cover":{"lt":10}}'
```

To read more about `query` option please look at [pystac_client documentation](https://pystac-client.readthedocs.io/en/stable/tutorials/cql2-filter.html)

### Dpwnload the asset from a STAC API

```sh
    t.stac.item -d url="https://earth-search.aws.element84.com/v1/" collection_id="sentinel-2-l2a" item_id="S2B_36QWD_20220301_0_L2A"
```

### Download and import filtering by asset

```sh
    t.stac.item url="https://earth-search.aws.element84.com/v1/" collection_id="sentinel-2-l2a" query='{"eo:cloud_cover":{"lt":10}}' asset=red,nir
```

## SEE ALSO

*Requirements
[t.stac.collection](https://grass.osgeo.org/grass-stable/manuals/t.stac.collection.html),
[t.stac.catalog](https://grass.osgeo.org/grass-stable/manuals/t.stac.catalog.html)*

[GRASS GIS Wiki: temporal data
processing](https://grasswiki.osgeo.org/wiki/Temporal_data_processing)

## AUTHORS

Corey T. White

## Sponsors

- [OpenPlains Inc.](https://openplains.com)
- [NCSU GeoForAll Lab](https://geospatial.ncsu.edu/geoforall/)

Center for Geospatial Analytics at North Carolina State University

## SOURCE CODE

Available at: [t.stac.item source code](https://github.com/OSGeo/grass-addons/tree/grass8/temporal/t.stac/t.stac.item)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/temporal/t.stac/t.stac.item))  
Latest change: Sunday Jun 01 16:46:08 2025 in commit [f2a0cbb](https://github.com/OSGeo/grass-addons/commit/f2a0cbb2f14932f50cdb1668282a292eb864584a)
