---
hide:
  - toc
---

# Topic: export

| Tool | Description |
|--------|-------------|
| [d.out.file](d.out.file.md) | Saves the contents of the active display monitor to a graphics file. |
| [d.to.rast](d.to.rast.md) | Saves the contents of the active display monitor to a raster map. |
| [db.out.ogr](db.out.ogr.md) | Exports attribute tables into various formats. |
| [r.external.out](r.external.out.md) | Redirects raster output to file utilizing GDAL library rather than storing in GRASS raster format. |
| [r.out.ascii](r.out.ascii.md) | Converts a raster map layer into a GRASS ASCII text file. |
| [r.out.bin](r.out.bin.md) | Exports a GRASS raster to a binary array. |
| [r.out.gdal](r.out.gdal.md) | Exports GRASS raster maps into GDAL supported formats. |
| [r.out.gridatb](r.out.gridatb.md) | Exports GRASS raster map to GRIDATB.FOR map file (TOPMODEL). |
| [r.out.mat](r.out.mat.md) | Exports a GRASS raster to a binary MAT-File. |
| [r.out.mpeg](r.out.mpeg.md) | Converts raster map series to MPEG movie. |
| [r.out.png](r.out.png.md) | Export a GRASS raster map as a non-georeferenced PNG image. |
| [r.out.pov](r.out.pov.md) | Converts a raster map layer into a height-field file for POV-Ray. |
| [r.out.ppm](r.out.ppm.md) | Converts a GRASS raster map to a PPM image file. |
| [r.out.ppm3](r.out.ppm3.md) | Converts 3 GRASS raster layers (R,G,B) to a PPM image file. |
| [r.out.vrml](r.out.vrml.md) | Exports a raster map to the Virtual Reality Modeling Language (VRML). |
| [r.out.vtk](r.out.vtk.md) | Converts raster maps into the VTK-ASCII format. |
| [r.out.xyz](r.out.xyz.md) | Exports a raster map to a text file as x,y,z values based on cell centers. |
| [r.pack](r.pack.md) | Exports a raster map as GRASS specific archive file |
| [r3.out.ascii](r3.out.ascii.md) | Converts a 3D raster map layer into a ASCII text file. |
| [r3.out.bin](r3.out.bin.md) | Exports a GRASS 3D raster map to a binary array. |
| [r3.out.netcdf](r3.out.netcdf.md) | Export a 3D raster map as netCDF file. |
| [r3.out.v5d](r3.out.v5d.md) | Exports GRASS 3D raster map to 3-dimensional Vis5D file. |
| [r3.out.vtk](r3.out.vtk.md) | Converts 3D raster maps into the VTK-ASCII format. |
| [t.rast.export](t.rast.export.md) | Exports space time raster dataset. |
| [t.rast.out.vtk](t.rast.out.vtk.md) | Exports space time raster dataset as VTK time series. |
| [t.vect.export](t.vect.export.md) | Exports a space time vector dataset as GRASS specific archive file. |
| [v.external.out](v.external.out.md) | Defines vector output format. |
| [v.out.ascii](v.out.ascii.md) | Exports a vector map to a GRASS ASCII vector representation. By default only features with category are exported. To export all features use 'layer=-1'. |
| [v.out.dxf](v.out.dxf.md) | Exports vector map to DXF file format. |
| [v.out.lidar](v.out.lidar.md) | Exports vector points as LAS point cloud Converts LAS LiDAR point clouds to a GRASS vector map with libLAS |
| [v.out.ogr](v.out.ogr.md) | Exports a vector map layer to any of the supported OGR vector formats. By default a vector map layer is exported to OGC GeoPackage format. |
| [v.out.pov](v.out.pov.md) | Converts GRASS x,y,z points to POV-Ray x,z,y format. |
| [v.out.svg](v.out.svg.md) | Exports a vector map to SVG file. |
| [v.out.vtk](v.out.vtk.md) | Converts a vector map to VTK ASCII output. |
| [v.pack](v.pack.md) | Exports a vector map as GRASS specific archive file |

*See also the corresponding keyword for additional references:*

<!-- topic_keyword { include: [export] } -->
