---
name: v.clean.ogr.py
description: Imports vector data into a GRASS vector map, cleans the data topologically, and exports them again using OGR library.
keywords: [ vector, cleaning, OGR, topology, geometry, snapping ]
---

# v.clean.ogr.py

Imports vector data into a GRASS vector map, cleans the data topologically, and exports them again using OGR library.

=== "Command line"

    **v.clean.ogr.py**
    [**-luf**]
    **input**=*string*
    **layer**=*string*
    [**where**=*sql_query*]
    [**encoding**=*string*]
    [**key**=*string*]
    [**geometry**=*name*]
    [**snap**=*float*]
    [**min_area**=*float*]
    **output**=*name*
    **format**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.clean.ogr.py input=string layer=string output=name format=GPKG
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.clean.ogr.py***",
        **input**,
        **layer**,
        **where**=*None*,
        **encoding**=*None*,
        **key**=*None*,
        **geometry**=*None*,
        **snap**=*-1*,
        **min_area**=*0*,
        **output**,
        **format**=*"GPKG"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.clean.ogr.py", input="string", layer="string", output="name", format="GPKG")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_clean_ogr_py*(**input**,
        **layer**,
        **where**=*None*,
        **encoding**=*None*,
        **key**=*None*,
        **geometry**=*None*,
        **snap**=*-1*,
        **min_area**=*0*,
        **output**,
        **format**=*"GPKG"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_clean_ogr_py(input="string", layer="string", output="name", format="GPKG")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of OGR datasource to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: directory containing shapefiles  
    **layer**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;OGR layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Examples: shapefile name without .shp  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **encoding**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Encoding value for attribute data  
    &nbsp;&nbsp;&nbsp;&nbsp;Overrides encoding interpretation, useful when importing ESRI Shapefile  
    **key**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column used for categories  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given, categories are generated as unique values and stored in 'cat' column  
    **geometry**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of geometry column  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given, all geometry columns from the input are used  
    **snap**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Snapping threshold for boundaries (map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-1' for no snap  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **min_area**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum size of areas to be retained in output (square meters)  
    &nbsp;&nbsp;&nbsp;&nbsp;Disabled with values &lt;= 0  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output OGR datasource  
    &nbsp;&nbsp;&nbsp;&nbsp;Examples: filename for a GeoPackage, directory for shapefiles  
    **format**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Data format to write  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GPKG*  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;List available OGR layers in data source and exit  
    **-u**  
    &nbsp;&nbsp;&nbsp;&nbsp;Open an existing output OGR datasource for update  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;List supported output formats and exit  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of OGR datasource to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: directory containing shapefiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, datasource  
    **layer** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;OGR layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Examples: shapefile name without .shp  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, datasource_layer  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **encoding** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Encoding value for attribute data  
    &nbsp;&nbsp;&nbsp;&nbsp;Overrides encoding interpretation, useful when importing ESRI Shapefile  
    **key** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column used for categories  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given, categories are generated as unique values and stored in 'cat' column  
    **geometry** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of geometry column  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given, all geometry columns from the input are used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **snap** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Snapping threshold for boundaries (map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-1' for no snap  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **min_area** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum size of areas to be retained in output (square meters)  
    &nbsp;&nbsp;&nbsp;&nbsp;Disabled with values &lt;= 0  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output OGR datasource  
    &nbsp;&nbsp;&nbsp;&nbsp;Examples: filename for a GeoPackage, directory for shapefiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data format to write  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GPKG*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *u*, *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available OGR layers in data source and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Open an existing output OGR datasource for update  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List supported output formats and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of OGR datasource to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: directory containing shapefiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, datasource  
    **layer** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;OGR layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Examples: shapefile name without .shp  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, datasource_layer  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **encoding** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Encoding value for attribute data  
    &nbsp;&nbsp;&nbsp;&nbsp;Overrides encoding interpretation, useful when importing ESRI Shapefile  
    **key** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column used for categories  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given, categories are generated as unique values and stored in 'cat' column  
    **geometry** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of geometry column  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given, all geometry columns from the input are used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **snap** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Snapping threshold for boundaries (map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-1' for no snap  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **min_area** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum size of areas to be retained in output (square meters)  
    &nbsp;&nbsp;&nbsp;&nbsp;Disabled with values &lt;= 0  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output OGR datasource  
    &nbsp;&nbsp;&nbsp;&nbsp;Examples: filename for a GeoPackage, directory for shapefiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data format to write  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GPKG*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *u*, *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available OGR layers in data source and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Open an existing output OGR datasource for update  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List supported output formats and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.clean.ogr* cleans non-topological polygons in an OGR datasource by
importing, cleaning, and exporting these polgons. This module should not
be used with polygons that are correctly overlapping, e.g. buffers.

*v.clean.ogr* imports vector data from files and database connections
supported by the [OGR](https://gdal.org/) library into a temporary
location. Only one input layer is imported.

Polygons in the input layer are automatically cleaned during impport.
More thorough cleaning can be achieved by using the **snap** and
**min\_area** options.

The cleaned result is exported to the selected **output** datasource
with "\_clean" appended to the input layer name. Any overlaps are
exported with "\_overlaps" appended to the input layer name.

### Supported Vector Formats

*v.clean.ogr* uses the OGR library which supports various vector data
formats including
[GeoPackage](https://gdal.org/drivers/vector/gpkg.html), [ESRI
Shapefile](https://gdal.org/drivers/vector/shapefile.html), [Mapinfo
File](https://gdal.org/drivers/vector/mitab.html), UK .NTF, SDTS, TIGER,
IHO S-57 (ENC), DGN, GML, GPX, AVCBin, REC, Memory, OGDI, and
PostgreSQL, depending on the local OGR installation. For details see the
[OGR web site](https://gdal.org/drivers/vector/index.html). The OGR
(Simple Features Library) is part of the [GDAL](https://gdal.org)
library, hence GDAL needs to be installed to use *v.clean.ogr*.

The list of actually supported formats can be printed by **-f** flag.

## NOTES

### Topology cleaning

When importing polygons, non-topological polygons are converted to
topological areas. If the input polygons contain errors (unexpected
overlapping areas, small gaps between polygons, or warnings about being
unable to calculate centroids), the import might need to be repeated
using a *snap* value as suggested in the output messages.

The *snap* threshold defines the maximal distance from one to another
vertex in map units (for latitude-longitude locations in degree). If
there is no other vertex within *snap* distance, no snapping will be
done. Note that a too large value can severely damage area topology,
beyond repair.

Further cleaning can be achieved by removing small areas using the
**min\_area** option. Note that units are always squaremeters. Values
for **min\_area** should generally be small, a value of 0.5 can already
clean up lots of artefacts.

## EXAMPLE

Cleaning polygons in a Shapefile in the current directory
*research\_area*

```sh
v.clean.ogr input=research_area layer=research_area output=research_area \
            snap=1e-4 min_area=1 -u --overwrite
```

Two new Shapefile layers "research\_area\_clean" and
"research\_area\_overlaps" may be created in the same directory.

## SEE ALSO

*[v.in.ogr](https://grass.osgeo.org/grass-stable/manuals/v.in.ogr.html),
[v.clean](https://grass.osgeo.org/grass-stable/manuals/v.clean.html),
[v.out.ogr](https://grass.osgeo.org/grass-stable/manuals/v.out.ogr.html)*

## AUTHOR

Markus Metz

## SOURCE CODE

Available at: [v.clean.ogr source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.clean.ogr)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.clean.ogr))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
