---
name: v.db.connect
description: Prints/sets DB connection for a vector map to attribute table.
keywords: [ vector, attribute table, database, layer ]
---

# v.db.connect

Prints/sets DB connection for a vector map to attribute table.

=== "Command line"

    **v.db.connect**
    [**-pgcd**]
    **map**=*name*
    [**driver**=*name*]
    [**database**=*name*]
    [**table**=*name*]
    [**key**=*name*]
    [**layer**=*string*]
    [**separator**=*character*]
    [**format**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.db.connect map=name
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***v.db.connect***",
        **map**,
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **table**=*None*,
        **key**=*"cat"*,
        **layer**=*"1"*,
        **separator**=*None*,
        **format**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("v.db.connect", map="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_db_connect*(**map**,
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **table**=*None*,
        **key**=*"cat"*,
        **layer**=*"1"*,
        **separator**=*None*,
        **format**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_db_connect(map="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **table**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    **key**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of key column  
    &nbsp;&nbsp;&nbsp;&nbsp;Must refer to an integer column  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cat*  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: layer number[/layer name]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for printing output  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    **format**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print all map connection parameters and exit  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print all map connection parameters in a legacy format [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;Order: layer[/layer name] table key database driverThis flag is deprecated and will be removed in a future release. Use format=csv instead.  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print types/names of table columns for specified layer and exit  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Delete connection for certain layer (not the table)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **key** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of key column  
    &nbsp;&nbsp;&nbsp;&nbsp;Must refer to an integer column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cat*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: layer number[/layer name]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for printing output  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *g*, *c*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print all map connection parameters and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print all map connection parameters in a legacy format [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Order: layer[/layer name] table key database driverThis flag is deprecated and will be removed in a future release. Use format=csv instead.  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print types/names of table columns for specified layer and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Delete connection for certain layer (not the table)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **key** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of key column  
    &nbsp;&nbsp;&nbsp;&nbsp;Must refer to an integer column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cat*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: layer number[/layer name]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for printing output  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *g*, *c*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print all map connection parameters and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print all map connection parameters in a legacy format [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Order: layer[/layer name] table key database driverThis flag is deprecated and will be removed in a future release. Use format=csv instead.  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print types/names of table columns for specified layer and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Delete connection for certain layer (not the table)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.db.connect* prints or sets database connection for a vector map. The
user can add or remove link to attribute table on the certain layer.

## NOTE

Connection information (driver, database, table, key) is stored for each
map, in the file

```sh
<database>/<project>/<mapset>/vector/<map>/dbln
```

If parameters for database connection are already set with
[db.connect](db.connect.md), they are taken as default values and do not
need to be specified each time.

When printing database connection (*p* or *g* flag) the parameter
*layer* is ignored, i.e. **all** connections are printed to the output.

**Attention:** Removing a vector map will also delete all tables linked
to it! If you use [v.db.connect](db.connect.md) to link further tables
to your map, it is advisable to make a copy from those tables first and
connect the copied tables to the vector map (see also
[v.overlay](v.overlay.md)).

The **-g** flag is deprecated and will be removed in a future release. Please
use **format=csv** option with the **-p** flag instead.

## EXAMPLE

Note: The default database backend setting is SQLite.

### Print database connection

Print all database connection parameters for vector map.

```sh
v.db.connect -p map=roads
```

Print column types and names of table linked to vector map.

```sh
v.db.connect -c map=roads
```

### Print database connection using Python

Print all database connection parameters for vector map.

```python
import grass.script as gs

data = gs.parse_command("v.db.connect", map="roadsmajor", flags="p", format="json")
print(data)
```

Possible output:

```text
[{'layer': 1, 'layer_name': 'roadsmajor', 'table': 'roadsmajor', 'key': 'cat', 'database': '/grassdata/nc_spm_08_grass7/PERMANENT/sqlite/sqlite.db', 'driver': 'sqlite'}]
```

Print column types and names of table linked to vector map.

```python
import grass.script as gs

data = gs.parse_command("v.db.connect", map="roadsmajor", flags="c", format="json")
print(data)
```

Possible output:

```text
[{'name': 'cat', 'sql_type': 'INTEGER', 'is_number': True}, {'name': 'MAJORRDS_', 'sql_type': 'DOUBLE PRECISION', 'is_number': True}, {'name': 'ROAD_NAME', 'sql_type': 'CHARACTER', 'is_number': False}, {'name': 'MULTILANE', 'sql_type': 'CHARACTER', 'is_number': False}, {'name': 'PROPYEAR', 'sql_type': 'INTEGER', 'is_number': True}, {'name': 'OBJECTID', 'sql_type': 'INTEGER', 'is_number': True}, {'name': 'SHAPE_LEN', 'sql_type': 'DOUBLE PRECISION', 'is_number': True}]
```

### Connect vector map to database (DBF driver)

Connect vector map to DBF table without or with variables.  

Using default DB connection:

```sh
v.db.connect map=vectormap table=table
```

Using hardcoded path to DBF directory (not recommended):  

```sh
v.db.connect map=vectormap table=table \
             database=/home/user/grassdata/spearfish60/PERMANENT/dbf
```

Using variable as DBF directory definition, single quotes must be
used:  

```sh
v.db.connect map=vectormap table=table \
             database='$GISDBASE/$LOCATION_NAME/$MAPSET/dbf/'
```

Connect vector map layer 2 and key ID to database with variables (note:
if needed, single quotes must be used for the *database* parameter):

```sh
v.db.connect map=vectormap table=table layer=2 key=ID
```

### Connect vector map to database (SQLite driver)

Very similar to DBF driver example above.

```sh
db.connect driver=sqlite database='$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db'
db.tables -p
v.db.connect map=vectormap table=table driver=sqlite \
             database='$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db'
v.db.connect -p map=vectormap
```

### Connect vector map to database (MySQL driver)

```sh
# note: connection which requires password
db.connect driver=mysql database="host=dbserver.foo.org,dbname=my_database"
db.login user=joshua [password=xxx]
# ... or enter password interactively.

db.tables -p

# connect external table to layer 2:
v.db.connect map=my_map table=my_mysql_table key=baz layer=2
v.db.connect -p my_map
```

### Connect vector map to database (PostgreSQL driver)

```sh
# note: connection without password being asked
v.db.connect map=vectormap table=table layer=1 key=oid driver=pg \
             database="host=myserver.itc.it,dbname=mydb,user=name" \
             table=mytable key=id
```

### Store geometry in GRASS but attributes in PostgreSQL

This example illustrates a mixed data storage with possibility to update
attributes in an external PostgreSQL database:

```sh
# Check current settings for attribute storage:
db.connect -p

# Import table from PostgreSQL to new map
# (NOTE: output map name needs to be different from table name in
#        case that GRASS is connected to PostgreSQL):
v.in.db driver=pg database="host=localhost,dbname=meteo" \
        table=mytable x=lon y=lat key=cat out=mytable

v.db.connect map=mytable -p

# Cancel table connection between map and attribute table:
v.db.connect map=mytable -d
v.db.connect map=mytable -p

# Drop table which was replicated due to import:
db.tables -p
echo "DROP TABLE mytable" | db.execute
db.tables -p

# reconnect map to table in PostgreSQL:
v.db.connect map=mytable driver=pg database="host=localhost,dbname=meteo" \
        table=mytable key=cat

# Now the geometry is stored in GRASS while the attributes are stored
# in PostgreSQL.
```

An alternative is to create a "view" of only ID, x, y \[,z\] columns and
to use [v.in.db](v.in.db.md) on this view, then connect the original
table to the geometry. This will be faster if the original table is very
large.

### Store geometry in GRASS but attributes in PostGIS

This example illustrated a mixed data storage with possibility top
update attributes in external PostGIS database:

```sh
# Check current settings for attribute storage:
db.connect -p

# Import table from PostGIS to new map
# (NOTE: output map name needs to be different from table name in
#        case that GRASS is connected to PostGIS):
v.in.db driver=pg database="host=localhost,dbname=meteo" \
        table=mytable x="x(geom)" y="y(geom)" key=cat out=mytable

v.db.connect map=mytable -p

# Cancel table connection between map and attribute table:
v.db.connect map=mytable -d
v.db.connect map=mytable -p

# Drop table which was replicated due to import:
db.tables -p
echo "DROP TABLE mytable" | db.execute
db.tables -p

# reconnect map to table in PostGIS:
v.db.connect map=mytable driver=pg database="host=localhost,dbname=meteo" \
        table=mytable key=cat

# Now the geometry is stored in GRASS while the attributes are stored
# in PostGIS.
```

## SEE ALSO

*[db.connect](db.connect.md), [db.copy](db.copy.md),
[db.tables](db.tables.md), [v.db.addtable](v.db.addtable.md),
[v.db.droptable](v.db.droptable.md),
[v.db.addcolumn](v.db.addcolumn.md),
[v.db.dropcolumn](v.db.dropcolumn.md), [v.external](v.external.md),
[v.in.db](v.in.db.md), [v.overlay](v.overlay.md)*

*[GRASS SQL interface](sql.md)*

## AUTHOR

Radim Blazek, ITC-Irst, Trento, Italy

## SOURCE CODE

Available at: [v.db.connect source code](https://github.com/OSGeo/grass/tree/main/vector/v.db.connect)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.db.connect))  
Latest change: Thursday Oct 02 14:39:13 2025 in commit [1850489](https://github.com/OSGeo/grass/commit/1850489bf42c72d8dcfe2e4db1738441b4a7dc43)
