---
name: v.external.all.py
description: Links all OGR layers available in given OGR datasource.
keywords: [ vector, external ]
---

# v.external.all.py

Links all OGR layers available in given OGR datasource.

=== "Command line"

    **v.external.all.py**
    [**-l**]
    **input**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.external.all.py input=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.external.all.py***",
        **input**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.external.all.py", input="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_external_all_py*(**input**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_external_all_py(input="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input OGR or PostGIS data source  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;List available layers in data source and exit  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input OGR or PostGIS data source  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available layers in data source and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input OGR or PostGIS data source  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available layers in data source and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.external.all* creates (using
*[v.external](https://grass.osgeo.org/grass-stable/manuals/v.external.html)*)
in the current mapset new pseudo-vector maps for all OGR layers from
given OGR datasource (**input** option).

## EXAMPLES

### PostGIS

List available feature tables in given PostGIS database

```sh
v.external.all -l input=PG:dbname=pgis_nc

PostGIS database contains 55 feature table(s):
boundary_county
boundary_municp
bridges
busroute1
busroute11
busroute6
busroute_a
busroutesall
busstopsall
censusblk_swwake
census_wake2000
...
```

Create links (ie. pseudo-vector maps) in the current mapset for all
PostGIS feature tables

```sh
v.external.all input=PG:dbname=pgis_nc
```

### Esri Shapefile

```sh
v.external.all -l input=~/geodata/ncshape/
Data source (format 'ESRI Shapefile')
contains 44 layers:
poi_names_wake
schools_wake
urbanarea
geodetic_swwake_pts
usgsgages
busroute_a
busroute6
hospitals
...
```

```sh
v.external.all -l input=~/geodata/ncshape/
```

## AUTHOR

Martin Landa, Czech Technical University in Prague

## SOURCE CODE

Available at: [v.external.all source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.external.all)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.external.all))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
