---
name: v.faultdirections.py
description: Creates a polar plot of fault directions
keywords: [ display, vector, geology ]
---

# v.faultdirections.py

Creates a polar plot of fault directions

=== "Command line"

    **v.faultdirections.py**
    [**-a**]
    **map**=*name*
    **column**=*name*
    [**step**=*integer*]
    [**legend_angle**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.faultdirections.py map=name column=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.faultdirections.py***",
        **map**,
        **column**,
        **step**=*10*,
        **legend_angle**=*0.0*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.faultdirections.py", map="name", column="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_faultdirections_py*(**map**,
        **column**,
        **step**=*10*,
        **legend_angle**=*0.0*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_faultdirections_py(map="name", column="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute column containing azimuth  
    **step**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step of binning (in degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **legend_angle**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle at which to put the axis labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use absolute values in legend, instead of percentages  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute column containing azimuth  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step of binning (in degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **legend_angle** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle at which to put the axis labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use absolute values in legend, instead of percentages  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute column containing azimuth  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step of binning (in degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **legend_angle** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle at which to put the axis labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use absolute values in legend, instead of percentages  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.faultdirections* draws a polar barplot of fault directions, with
values binned according to the *step* parameter. Directions have to be
stored in an attribute column of the vector map containing the faults.

The parameter *legend\_angle* allows positioning the radial axis. By
setting the flag *a* the user can choose to display absolute number of
lines as radial axis labels instead of the default percentages.

## NOTES

The module
[v.to.db](https://grass.osgeo.org/grass-stable/manuals/v.to.db.html) can
be used to load azimuth directions into the attribute table.

The plot can be saved to a graphics file interactively from the
matplotlib window.

## DEPENDENCIES

This module depends on matplotlib and on tkinter (aka python-tk). It is
the users responsibility to make sure both are installed.

## EXAMPLE

Load azimuth directions into the attribute map and draw plot:

```sh
v.db.addcolumn faultmap col="azimuth double precision"
v.to.db faultmap option=azimuth colum=azimuth
v.faultdirections faultmap column=azimuth step=10
```

## SEE ALSO

*[v.to.db](https://grass.osgeo.org/grass-stable/manuals/v.to.db.html)*

## AUTHOR

Moritz Lennert

## SOURCE CODE

Available at: [v.faultdirections source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.faultdirections)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.faultdirections))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
