---
name: v.flexure.py
description: Lithospheric flexure: gridded deflections from scattered point loads
keywords: [ vector, geophysics ]
---

# v.flexure.py

Lithospheric flexure: gridded deflections from scattered point loads

=== "Command line"

    **v.flexure.py**
    **input**=*name*
    [**layer**=*string*]
    **column**=*name* [,*name*,...]
    **te**=*float*
    **te_units**=*string*
    **output**=*name*
    [**raster_output**=*name*]
    [**g**=*float*]
    [**ym**=*float*]
    [**nu**=*float*]
    [**rho_fill**=*float*]
    [**rho_m**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.flexure.py input=name column=name te=0.0 te_units=m output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.flexure.py***",
        **input**,
        **layer**=*"1"*,
        **column**,
        **te**,
        **te_units**,
        **output**,
        **raster_output**=*None*,
        **g**=*9.8*,
        **ym**=*65E9*,
        **nu**=*0.25*,
        **rho_fill**=*0*,
        **rho_m**=*3300*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.flexure.py", input="name", column="name", te=0.0, te_units="m", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_flexure_py*(**input**,
        **layer**=*"1"*,
        **column**,
        **te**,
        **te_units**,
        **output**,
        **raster_output**=*None*,
        **g**=*9.8*,
        **ym**=*65E9*,
        **nu**=*0.25*,
        **rho_fill**=*0*,
        **rho_m**=*3300*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_flexure_py(input="name", column="name", te=0.0, te_units="m", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of loads (thickness \* area \* density \* g) [N]  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer containing load values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Column containing load values [N]  
    **te**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Elastic thicnkess: scalar; unis chosen in "te_units"  
    **te_units**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Units for elastic thickness  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m,  km*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector points map of vertical deflections [m]  
    **raster_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map of vertical deflections [m]  
    **g**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;gravitational acceleration at surface [m/s^2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9.8*  
    **ym**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Young's Modulus [Pa]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *65E9*  
    **nu**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Poisson's ratio  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.25*  
    **rho_fill**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Density of material that fills flexural depressions [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **rho_m**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mantle density [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3300*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of loads (thickness \* area \* density \* g) [N]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer containing load values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column containing load values [N]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **te** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elastic thicnkess: scalar; unis chosen in "te_units"  
    **te_units** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units for elastic thickness  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m,  km*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector points map of vertical deflections [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **raster_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map of vertical deflections [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **g** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;gravitational acceleration at surface [m/s^2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9.8*  
    **ym** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Young's Modulus [Pa]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *65E9*  
    **nu** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Poisson's ratio  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.25*  
    **rho_fill** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Density of material that fills flexural depressions [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **rho_m** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mantle density [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3300*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of loads (thickness \* area \* density \* g) [N]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer containing load values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column containing load values [N]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **te** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elastic thicnkess: scalar; unis chosen in "te_units"  
    **te_units** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units for elastic thickness  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m,  km*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector points map of vertical deflections [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **raster_output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map of vertical deflections [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **g** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;gravitational acceleration at surface [m/s^2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9.8*  
    **ym** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Young's Modulus [Pa]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *65E9*  
    **nu** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Poisson's ratio  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.25*  
    **rho_fill** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Density of material that fills flexural depressions [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **rho_m** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mantle density [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3300*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.flexure* computes how the rigid outer shell of a planet deforms
elastically in response to surface-normal loads by solving equations for
plate bending. This phenomenon is known as "flexural isostasy" and can
be useful in cases of glacier/ice-cap/ice-sheet loading, sedimentary
basin filling, mountain belt growth, volcano emplacement, sea-level
change, and other geologic processes. *v.flexure* and
[r.flexure](r.flexure.md) are the GRASS GIS interfaces to the the model
[**gFlex**](https://csdms.colorado.edu/wiki/Model:GFlex). As both
*v.flexure* and [r.flexure](r.flexure.md) are interfaces to gFlex, this
must be downloaded and installed. The most recent versions of **gFlex**
are available from <https://github.com/awickert/gFlex>, and installation
instructions are avaliable on that page via the *README.md* file.

## NOTES

**input** is a vector points file containing the loads in units of
force. Typically, this will be a representation of a distributed field
of loads as a set of points, so the user will implicitly include the
area over which a stress (vertical load) acts into the quantities in the
database table of **input**.

**te**, written in standard text as T<sub>e</sub>, is the lithospheric
elastic thickness.

**output** is provided as a grid of vector points corresponding to the
GRASS region when this command is invoked. Be sure to use *g.region* to
properly set the input region\! **raster\_output** is the same output,
except converted to a raster grid at the same resolution as the current
computational region. If you have a grid spacing that is much smaller
than a flexural wavelength, it is possible to interpolate the vector
output to a much finer resolution than this raster output provides.

The [Community Surface Dynamics Modeling
System](https://csdms.colorado.edu), into which **gFlex** is integrated,
is a community-driven effort to build an open-source modeling
infrastructure for Earth-surface processes.

## SEE ALSO

*[v.flexure](v.flexure.md),
[v.surf.bspline](https://grass.osgeo.org/grass-stable/manuals/v.surf.bspline.html)*

## REFERENCES

Wickert, A. D. (2015), Open-source modular solutions for flexural
isostasy: gFlex v1.0, *Geoscientific Model Development Discussions*,
*8*(6), 4245–4292, doi:10.5194/gmdd-8-4245-2015.

Wickert, A. D., G. E. Tucker, E. W. H. Hutton, B. Yan, and S. D. Peckham
(2011), [Feedbacks between surface processes and flexural isostasy: a
motivation for coupling
models](https://csdms.colorado.edu/csdms_wiki/images/Andrew_Wickert_CSDMS_2011_annual_meeting.pdf),
in *CSDMS 2011 Meeting: Impact of time and process scales*, Student
Keynote, Boulder, CO.

van Wees, J. D., and S. Cloetingh (1994), A Finite-Difference Technique
to Incorporate Spatial Variations In Rigidity and Planar Faults Into 3-D
Models For Lithospheric Flexure, *Geophysical Journal International*,
*117*(1), 179–195,
[doi:10.1111/j.1365-246X.1994.tb03311.x](https://doi.org/10.1111/j.1365-246X.1994.tb03311.x).

## AUTHOR

Andrew D. Wickert

## SOURCE CODE

Available at: [v.flexure source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.flexure)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.flexure))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
