---
name: v.in.gns.py
description: Imports US-NGA GEOnet Names Server (GNS) country files into a GRASS vector points map.
keywords: [ vector, import, gazetteer ]
---

# v.in.gns.py

Imports US-NGA GEOnet Names Server (GNS) country files into a GRASS vector points map.

=== "Command line"

    **v.in.gns.py**
    **input**=*name*
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.gns.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.gns.py***",
        **input**,
        **output**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.gns.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_gns_py*(**input**,
        **output**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_gns_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input uncompressed GNS file from NGA (with .txt extension)  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input uncompressed GNS file from NGA (with .txt extension)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input uncompressed GNS file from NGA (with .txt extension)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.gns* imports US-NGA GEOnet Names Server (GNS) country files
(Gazetteer data) into a GRASS vector points map. The country files can
be downloaded from the NGA GNS Web Server (see below). The script
generates a vector point map. Only original files can be processed
(unzip compressed file first). These GNS files are encoded in UTF-8
which is maintained in the GRASS database.

## NOTES

The current DB connection is used to write the database table.

Generally, column names longer that 10 characters are shortened to 10
characters to meet the DBF column name restrictions. If this is a
problem consider choosing another database driver with *db.connect*.

To filter outliers (points outside of a country), the *v.select* module
can be used to perform point-in-polygon tests. *v.select* saves only the
GNS points falling into a country polygon into the new points map.

## SEE ALSO

*[db.connect](https://grass.osgeo.org/grass-stable/manuals/db.connect.html),
[v.select](https://grass.osgeo.org/grass-stable/manuals/v.select.html)*

## REFERENCES

[GEOnet Names Server files for countries and
territories](http://earth-info.nga.mil/gns/html/)  
[Column names explanations](http://earth-info.nga.mil/gns/html/help.htm)

## AUTHOR

Markus Neteler, MPBA Group, ITC-irst, Trento, Italy

## SOURCE CODE

Available at: [v.in.gns source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.in.gns)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.in.gns))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
