---
name: v.in.natura2000.py
description: importing of Natura 2000 spatial data of protected areas
keywords: [ vector, geometry ]
---

# v.in.natura2000.py

importing of Natura 2000 spatial data of protected areas

=== "Command line"

    **v.in.natura2000.py**
    [**-lbmhst**]
    **input**=*name*
    [**output**=*name*]
    [**sitetype**=*string*]
    [**habitat_code**=*string*]
    [**species_code**=*string*]
    [**biogeographic_region**=*string*]
    [**member_state**=*string*]
    [**existing_layer**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.natura2000.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.natura2000.py***",
        **input**,
        **output**=*None*,
        **sitetype**=*None*,
        **habitat_code**=*None*,
        **species_code**=*None*,
        **biogeographic_region**=*None*,
        **member_state**=*None*,
        **existing_layer**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.natura2000.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_natura2000_py*(**input**,
        **output**=*None*,
        **sitetype**=*None*,
        **habitat_code**=*None*,
        **species_code**=*None*,
        **biogeographic_region**=*None*,
        **member_state**=*None*,
        **existing_layer**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_natura2000_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;name of imported spatial data set  
    **sitetype**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select site type of input (A, B or C)  
    **habitat_code**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select habitat code of input  
    **species_code**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select species of input  
    **biogeographic_region**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select biogeographic region of input  
    **member_state**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select member state of input  
    **existing_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import of existing layer  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print available layer  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print list of biogeographic regions  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print list of EU member states codes  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print list of habitats of community interest  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print list of species of community interest  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print list of protected area site types  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;name of imported spatial data set  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **sitetype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select site type of input (A, B or C)  
    **habitat_code** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select habitat code of input  
    **species_code** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select species of input  
    **biogeographic_region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select biogeographic region of input  
    **member_state** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select member state of input  
    **existing_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import of existing layer  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *b*, *m*, *h*, *s*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print available layer  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print list of biogeographic regions  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print list of EU member states codes  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print list of habitats of community interest  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print list of species of community interest  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print list of protected area site types  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;name of imported spatial data set  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **sitetype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select site type of input (A, B or C)  
    **habitat_code** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select habitat code of input  
    **species_code** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select species of input  
    **biogeographic_region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select biogeographic region of input  
    **member_state** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select member state of input  
    **existing_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import of existing layer  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *b*, *m*, *h*, *s*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print available layer  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print list of biogeographic regions  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print list of EU member states codes  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print list of habitats of community interest  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print list of species of community interest  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print list of protected area site types  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.natura2000* imports [Natura 2000 protected
areas](https://www.eea.europa.eu/data-and-maps/data/ds_resolveuid/52E54BF3-ACDB-4959-9165-F3E4469BE610).
The tool is implemented for the sqlite/spatialite version of this data
(size \> 1 GB). Listing und import operations of *v.in.natura2000* may
be slow due to the huge data file size. Listing (already availabe
layers, biogeographic regions, EU member states codes, habitat codes,
species codes, protected area site types) and importing (all data,
protected areas of a defined habitat/species/member states/biogeographic
region) is limited to some small selection of wide range of possible
cases.

### Important notes

Topological correctness of the input data is not guaranteed, overlapping
of (many) polygones may occur. According to GRASS GIS topological model,
imported data may have more layers in case of overlapping polygones .
The sqlite/spatialite data is shipped in EPSG:3035 projection. The
script uses
[pyspatialite](https://pypi.org/project/pyspatialite/3.0.1-alpha-0) for
connecting to the sqlite/spatialite database.

With the database update by end 2015 the column *PERCENTAGE\_COVER* in
the HABITATS table was renamed to *PERCENTAGECOVER*. The addon script
was adapted accordingly; for Natura 2000 database versions \< 2015, the
column has to be renamed back.

Depending on which taxonomy was used to identify species, different
species codes may be used for species across EU member states. Check the
[Reference Portal for
Natura 2000](https://cdr.eionet.europa.eu/help/natura2000) (*Codelist
for species (Annex II,IV,V)*) for species and their synonyms.

## EXAMPLE

```sh
# list spatial layer(s) already availabe in the sqlite/spatialite database
v.in.natura2000 -l input=Natura2000_end2014.sqlite

# import already available spatial layer
v.in.natura2000 input=Natura2000_end2014.sqlite existing_layer=sv1800

# list biogeographic regions
v.in.natura2000 -b input=Natura2000_end2014.sqlite

# list EU member states codes
v.in.natura2000 -m input=Natura2000_end2014.sqlite

# list habitats of community interest
v.in.natura2000 -h input=Natura2000_end2014.sqlite

# list species of community interest
v.in.natura2000 -s input=Natura2000_end2014.sqlite

# list protected area site types
v.in.natura2000 -t input=Natura2000_end2014.sqlite

# import protected areas of type A
v.in.natura2000 input=Natura2000_end2014.sqlite /
output=pa_typeA sitetype=A

# import protected areas with habitat 3230
v.in.natura2000 input=Natura2000_end2014.sqlite /
output=pa_habitat3230 habitat_code=3230

# import protected areas with species 1800
v.in.natura2000 input=Natura2000_end2014.sqlite /
output=pa_species1800 species_code=1800

# import protected areas within the Alpine biogeographical region
v.in.natura2000 input=Natura2000_end2014.sqlite /
output=pa_alpineregion biogeographic_region=Alpine

# import protected areas of member state Austria
v.in.natura2000 input=Natura2000_end2014.sqlite /
output=pa_austria member_state=AT

 
```

## SEE ALSO

*[v.import](https://grass.osgeo.org/grass-stable/manuals/v.import.html),
[v.in.ogr](https://grass.osgeo.org/grass-stable/manuals/v.in.ogr.html),
[v.proj](https://grass.osgeo.org/grass-stable/manuals/v.proj.html)*

## AUTHOR

Helmut Kudrnovsky

## SOURCE CODE

Available at: [v.in.natura2000 source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.in.natura2000)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.in.natura2000))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
