---
name: v.in.ply
description: Creates a vector map from a PLY file.
keywords: [ vector, import ]
---

# v.in.ply

Creates a vector map from a PLY file.

=== "Command line"

    **v.in.ply**
    [**-tbp**]
    **input**=*name*
    **output**=*name*
    [**x**=*integer*]
    [**y**=*integer*]
    [**z**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.ply input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.ply***",
        **input**,
        **output**,
        **x**=*1*,
        **y**=*2*,
        **z**=*3*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.ply", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_ply*(**input**,
        **output**,
        **x**=*1*,
        **y**=*2*,
        **z**=*3*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_ply(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **x**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of vertex property used as x coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;First vertex property is 1  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **y**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of vertex property used as y coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;First vertex property is 1  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **z**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of vertex property used as z coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;First vertex property is 1. If 0, z coordinate is not used  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only print PLY element types and their properties.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **x** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of vertex property used as x coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;First vertex property is 1  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **y** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of vertex property used as y coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;First vertex property is 1  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **z** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of vertex property used as z coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;First vertex property is 1. If 0, z coordinate is not used  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *b*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only print PLY element types and their properties.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **x** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of vertex property used as x coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;First vertex property is 1  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **y** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of vertex property used as y coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;First vertex property is 1  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **z** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of vertex property used as z coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;First vertex property is 1. If 0, z coordinate is not used  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *b*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only print PLY element types and their properties.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.ply* imports a vector map in PLY vector format. A PLY file always
holds a number of vertices which are imported as points. PLY vertices
can have a number of properties in addition to their coordinates. These
properties are stored in an attribute table. For larger PLY files with
many vertices (\> 1000) it is highly recommended to not use DBF as
database driver, but SQLite (default in GRASS GIS 7), PostgreSQL or
MySQL, because the DBF driver is rather slow and can consume a lot of
memory. The database driver can be set with *db.connect*.

## NOTES

*v.in.ply* is designed for large point clouds with the possibility to
have only coordinates, and no attribute table (for speed reasons).

## EXAMPLES

```sh
v.in.ply input=myfile.ply output=myfile
```

## REFERENCES

<https://paulbourke.net/dataformats/ply>  
<https://sites.cc.gatech.edu/projects/large_models/ply.html>

## AUTHOR

Markus Metz

## SOURCE CODE

Available at: [v.in.ply source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.in.ply)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.in.ply))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
