---
name: v.neighborhoodmatrix.py
description: Exports the neighborhood matrix of polygons in a vector map
keywords: [ vector, neighborhood matrix ]
---

# v.neighborhoodmatrix.py

Exports the neighborhood matrix of polygons in a vector map

=== "Command line"

    **v.neighborhoodmatrix.py**
    [**-b**]
    **input**=*name*
    [**player**=*integer*]
    [**idcolumn**=*name*]
    [**output**=*name*]
    [**separator**=*character*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.neighborhoodmatrix.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.neighborhoodmatrix.py***",
        **input**,
        **player**=*1*,
        **idcolumn**=*None*,
        **output**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.neighborhoodmatrix.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_neighborhoodmatrix_py*(**input**,
        **player**=*1*,
        **idcolumn**=*None*,
        **output**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_neighborhoodmatrix_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **player**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer in map where polygons are to be found  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **idcolumn**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing polygon ids  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;create bidirectional matrix (same neighborhood relation repeated twice)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **player** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer in map where polygons are to be found  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **idcolumn** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing polygon ids  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;create bidirectional matrix (same neighborhood relation repeated twice)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **player** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer in map where polygons are to be found  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **idcolumn** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing polygon ids  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;create bidirectional matrix (same neighborhood relation repeated twice)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.neighborhoodmatrix* identifies all adjacency relations between
polygons in a vector map and exports these as a 2xn matrix where n is
the number of neighborhood relations with each relation only listed in
one direction (i.e. if a is neighbor of b, the list will contain a,b,
but not b,a) unless the *b* flag is specified. By default, neighbors are
identified by the category numbers. Using the *idcolumn* parameter the
user can define a column to use as identifier of the polygons. If a path
to an output file is specified, the matrix will be written to that file,
otherwise it will be sent to standard output.

## NOTES

Currently the module assumes that the layer above the layer containing
the polygons is empty and available for adding categories to boundaries.
The module uses *v.to.db* to determine neighborhood relations.

## EXAMPLE

Send the neighborhood matrix of the census tracts of the North Carolina
dataset to standard output identifying each tract by its category value:

```sh
v.neighborhoodmatrix in=census_wake2000
```

Idem, but identifying each tract by its STFID code and sending the
output to a file:

```sh
v.neighborhoodmatrix in=census_wake2000 idcolumn=STFID output=census_neighbors.csv
```

## SEE ALSO

*[v.to.db](https://grass.osgeo.org/grass-stable/manuals/v.to.db.html)*

## AUTHOR

Moritz Lennert

## SOURCE CODE

Available at: [v.neighborhoodmatrix source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.neighborhoodmatrix)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.neighborhoodmatrix))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
