---
name: v.out.ply
description: Exports a vector map to a PLY file.
keywords: [ vector, export, ply ]
---

# v.out.ply

Exports a vector map to a PLY file.

=== "Command line"

    **v.out.ply**
    [**-r**]
    **input**=*name*
    [**layer**=*string*]
    [**output**=*name*]
    [**columns**=*name* [,*name*,...]]
    [**dp**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.out.ply input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.out.ply***",
        **input**,
        **layer**=*"1"*,
        **output**=*"-"*,
        **columns**=*None*,
        **dp**=*6*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.out.ply", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_out_ply*(**input**,
        **layer**=*"1"*,
        **output**=*"-"*,
        **columns**=*None*,
        **dp**=*6*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_out_ply(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output PLY file  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **columns**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) to be exported  
    **dp**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits (floating point only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-32*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only export points falling within current 3D region (points mode)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output PLY file  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) to be exported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **dp** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits (floating point only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-32*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only export points falling within current 3D region (points mode)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output PLY file  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) to be exported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **dp** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits (floating point only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-32*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only export points falling within current 3D region (points mode)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.out.ply* converts a GRASS vector map in binary format to an ASCII
file in PLY format. Currently supported is points export only.
*v.out.ply* is designed for large point clouds and fairly fast if only
coordinates are exported. The export of attributes with the option
**columns** can slow down the export considerably.

If the **output** parameter is not given then the coordinates of any
*point* data within the vector map is sent to stdout.

## REFERENCES

<https://paulbourke.net/dataformats/ply>  
<https://sites.cc.gatech.edu/projects/large_models/ply.html>

## SEE ALSO

*[v.out.ascii](https://grass.osgeo.org/grass-stable/manuals/v.out.ascii.html),
[v.in.ply](v.in.ply.md)*

## AUTHOR

Markus Metz  
based on
[v.out.ascii](https://grass.osgeo.org/grass-stable/manuals/v.out.ascii.html)

## SOURCE CODE

Available at: [v.out.ply source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.out.ply)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.out.ply))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
