---
name: v.scatterplot.py
description: Plots the values of two columns in the attribute table of an input vector layer in a scatterplot.
keywords: [ vector, plot, scatterplot ]
---

# v.scatterplot.py

Plots the values of two columns in the attribute table of an input vector layer in a scatterplot.

=== "Command line"

    **v.scatterplot.py**
    [**-reg**]
    **map**=*name*
    **x**=*name*
    **y**=*name*
    [**type**=*string*]
    [**output**=*name*]
    [**plot_dimensions**=*string*]
    [**dpi**=*integer*]
    [**title**=*string*]
    [**fontsize**=*float*]
    [**marker**=*string*]
    [**s**=*float*]
    [**color**=*name*]
    [**rgbcolumn**=*name*]
    [**bins**=*string*]
    [**density_colormap**=*string*]
    [**trendline**=*string*]
    [**degree**=*integer*]
    [**line_color**=*name*]
    [**line_style**=*string*]
    [**line_width**=*float*]
    [**n**=*string*]
    [**ellipse_color**=*name*]
    [**ellipse_alpha**=*float*]
    [**ellipse_edge_style**=*string*]
    [**ellipse_edge_width**=*float*]
    [**groups**=*name*]
    [**groups_rgb**=*name*]
    [**ellipse_legend**=*string*]
    [**quadrants**=*string*]
    [**quandrant_linecolor**=*name*]
    [**quandrant_linewidth**=*float*]
    [**x_axis_limits**=*string*]
    [**y_axis_limits**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.scatterplot.py map=name x=name y=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.scatterplot.py***",
        **map**,
        **x**,
        **y**,
        **type**=*"scatter"*,
        **output**=*None*,
        **plot_dimensions**=*"6.4,4.8"*,
        **dpi**=*100*,
        **title**=*None*,
        **fontsize**=*10*,
        **marker**=*"o"*,
        **s**=*None*,
        **color**=*"black"*,
        **rgbcolumn**=*None*,
        **bins**=*"30,30"*,
        **density_colormap**=*"viridis"*,
        **trendline**=*None*,
        **degree**=*1*,
        **line_color**=*"darkgrey"*,
        **line_style**=*"--"*,
        **line_width**=*2*,
        **n**=*"2"*,
        **ellipse_color**=*"red"*,
        **ellipse_alpha**=*0.1*,
        **ellipse_edge_style**=*"-"*,
        **ellipse_edge_width**=*1.5*,
        **groups**=*None*,
        **groups_rgb**=*None*,
        **ellipse_legend**=*"yes"*,
        **quadrants**=*None*,
        **quandrant_linecolor**=*"grey"*,
        **quandrant_linewidth**=*1*,
        **x_axis_limits**=*None*,
        **y_axis_limits**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.scatterplot.py", map="name", x="name", y="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_scatterplot_py*(**map**,
        **x**,
        **y**,
        **type**=*"scatter"*,
        **output**=*None*,
        **plot_dimensions**=*"6.4,4.8"*,
        **dpi**=*100*,
        **title**=*None*,
        **fontsize**=*10*,
        **marker**=*"o"*,
        **s**=*None*,
        **color**=*"black"*,
        **rgbcolumn**=*None*,
        **bins**=*"30,30"*,
        **density_colormap**=*"viridis"*,
        **trendline**=*None*,
        **degree**=*1*,
        **line_color**=*"darkgrey"*,
        **line_style**=*"--"*,
        **line_width**=*2*,
        **n**=*"2"*,
        **ellipse_color**=*"red"*,
        **ellipse_alpha**=*0.1*,
        **ellipse_edge_style**=*"-"*,
        **ellipse_edge_width**=*1.5*,
        **groups**=*None*,
        **groups_rgb**=*None*,
        **ellipse_legend**=*"yes"*,
        **quadrants**=*None*,
        **quandrant_linecolor**=*"grey"*,
        **quandrant_linewidth**=*1*,
        **x_axis_limits**=*None*,
        **y_axis_limits**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_scatterplot_py(map="name", x="name", y="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input map  
    &nbsp;&nbsp;&nbsp;&nbsp;input vector layer  
    **x**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of x column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the column with x values  
    **y**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of y column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the column with y values  
    **type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot type  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of plot (scatter, density)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *scatter,  density*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *scatter*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output file (extension decides format)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output file. The format is determined by the file extension.  
    **plot_dimensions**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot dimensions (width,height)  
    &nbsp;&nbsp;&nbsp;&nbsp;Dimensions (width,height) of the figure in inches  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6.4,4.8*  
    **dpi**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;DPI  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of plot in dpi's  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **title**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot title  
    &nbsp;&nbsp;&nbsp;&nbsp;The title of the plot  
    **fontsize**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;The basis font size (default = 10)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **marker**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dot marker  
    &nbsp;&nbsp;&nbsp;&nbsp;Set dot marker (see https://matplotlib.org/stable/api/markers_api.html for options)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *o*  
    **s**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Marker size  
    &nbsp;&nbsp;&nbsp;&nbsp;Set marker size  
    **color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dot color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of dots  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **rgbcolumn**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;RGB column  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with RGB values defining the colors of the dots of the scatterplot  
    **bins**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;2D bins  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of bins in x and y dimension. Density is expressed as the number of points falling within the x and y boundaries of a bin.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30,30*  
    **density_colormap**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Density plot color map  
    &nbsp;&nbsp;&nbsp;&nbsp;Select the color map to be used for the density scatter plot  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *viridis, plasma, inferno, magma, cividis, Greys, Purples, Blues, Greens, Oranges, Reds, YlOrBr, YlOrRd, OrRd, PuRd, RdPu, BuPu, GnBu, PuBu, YlGnBu, PuBuGn, BuGn, YlGn*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *viridis*  
    **trendline**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *linear,  polynomial*  
    **degree**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Degree  
    &nbsp;&nbsp;&nbsp;&nbsp;Degree polynomial trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **line_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *darkgrey*  
    **line_style**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line style trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Line style trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *--*  
    **line_width**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;trendline width  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width of the trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **n**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;standard deviations  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw the covariance confidence ellipse(s) with radius of n standard deviations.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **ellipse_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ellipse color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the ellipse  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *red*  
    **ellipse_alpha**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Opacity ellipse fill.  
    &nbsp;&nbsp;&nbsp;&nbsp;Opacity of the fill color of the ellipse.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **ellipse_edge_style**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ellipse edge style  
    &nbsp;&nbsp;&nbsp;&nbsp;Line style of the ellipse  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **ellipse_edge_width**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ellipse edge width  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of the ellipse edge  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **groups**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column grouping the features in categories  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with categories. If selected, a separate ellipse will be drawn for each group/category  
    **groups_rgb**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;RGB column for ellipse categories  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with RGB values per category. These will be used to define the color of the ellipse.  
    **ellipse_legend**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;legend for ellipses  
    &nbsp;&nbsp;&nbsp;&nbsp;Print the legend for the ellipses (only for if ellipses for groups are drawn)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *yes, no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yes*  
    **quadrants**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;quadrants  
    &nbsp;&nbsp;&nbsp;&nbsp;Print the mean or median on x and y-axis  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mean, median*  
    **quandrant_linecolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the lines making up the quadrants  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *grey*  
    **quandrant_linewidth**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;quandrant line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width of the lines dividing the points in four quadrants  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **x_axis_limits**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;X axis range (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the X axis range to be displayed  
    **y_axis_limits**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Y axis range (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the Y axis range to be displayed  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reverse color map  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw a covariance confidence ellipse(s)  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Add grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Add grid lines  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input map  
    &nbsp;&nbsp;&nbsp;&nbsp;input vector layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **x** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of x column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the column with x values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **y** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of y column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the column with y values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot type  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of plot (scatter, density)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *scatter,  density*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *scatter*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output file (extension decides format)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output file. The format is determined by the file extension.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **plot_dimensions** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot dimensions (width,height)  
    &nbsp;&nbsp;&nbsp;&nbsp;Dimensions (width,height) of the figure in inches  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6.4,4.8*  
    **dpi** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;DPI  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of plot in dpi's  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot title  
    &nbsp;&nbsp;&nbsp;&nbsp;The title of the plot  
    **fontsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;The basis font size (default = 10)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **marker** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dot marker  
    &nbsp;&nbsp;&nbsp;&nbsp;Set dot marker (see https://matplotlib.org/stable/api/markers_api.html for options)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *o*  
    **s** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Marker size  
    &nbsp;&nbsp;&nbsp;&nbsp;Set marker size  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dot color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of dots  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **rgbcolumn** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;RGB column  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with RGB values defining the colors of the dots of the scatterplot  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **bins** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;2D bins  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of bins in x and y dimension. Density is expressed as the number of points falling within the x and y boundaries of a bin.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30,30*  
    **density_colormap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Density plot color map  
    &nbsp;&nbsp;&nbsp;&nbsp;Select the color map to be used for the density scatter plot  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *viridis, plasma, inferno, magma, cividis, Greys, Purples, Blues, Greens, Oranges, Reds, YlOrBr, YlOrRd, OrRd, PuRd, RdPu, BuPu, GnBu, PuBu, YlGnBu, PuBuGn, BuGn, YlGn*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *viridis*  
    **trendline** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *linear,  polynomial*  
    **degree** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Degree  
    &nbsp;&nbsp;&nbsp;&nbsp;Degree polynomial trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **line_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *darkgrey*  
    **line_style** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line style trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Line style trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *--*  
    **line_width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;trendline width  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width of the trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **n** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;standard deviations  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw the covariance confidence ellipse(s) with radius of n standard deviations.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **ellipse_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ellipse color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the ellipse  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *red*  
    **ellipse_alpha** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Opacity ellipse fill.  
    &nbsp;&nbsp;&nbsp;&nbsp;Opacity of the fill color of the ellipse.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **ellipse_edge_style** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ellipse edge style  
    &nbsp;&nbsp;&nbsp;&nbsp;Line style of the ellipse  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **ellipse_edge_width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ellipse edge width  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of the ellipse edge  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **groups** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column grouping the features in categories  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with categories. If selected, a separate ellipse will be drawn for each group/category  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **groups_rgb** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;RGB column for ellipse categories  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with RGB values per category. These will be used to define the color of the ellipse.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **ellipse_legend** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;legend for ellipses  
    &nbsp;&nbsp;&nbsp;&nbsp;Print the legend for the ellipses (only for if ellipses for groups are drawn)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *yes, no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yes*  
    **quadrants** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;quadrants  
    &nbsp;&nbsp;&nbsp;&nbsp;Print the mean or median on x and y-axis  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mean, median*  
    **quandrant_linecolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the lines making up the quadrants  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *grey*  
    **quandrant_linewidth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;quandrant line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width of the lines dividing the points in four quadrants  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **x_axis_limits** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;X axis range (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the X axis range to be displayed  
    **y_axis_limits** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Y axis range (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the Y axis range to be displayed  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *e*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse color map  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw a covariance confidence ellipse(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add grid lines  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input map  
    &nbsp;&nbsp;&nbsp;&nbsp;input vector layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **x** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of x column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the column with x values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **y** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of y column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the column with y values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot type  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of plot (scatter, density)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *scatter,  density*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *scatter*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output file (extension decides format)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output file. The format is determined by the file extension.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **plot_dimensions** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot dimensions (width,height)  
    &nbsp;&nbsp;&nbsp;&nbsp;Dimensions (width,height) of the figure in inches  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6.4,4.8*  
    **dpi** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;DPI  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of plot in dpi's  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot title  
    &nbsp;&nbsp;&nbsp;&nbsp;The title of the plot  
    **fontsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;The basis font size (default = 10)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **marker** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dot marker  
    &nbsp;&nbsp;&nbsp;&nbsp;Set dot marker (see https://matplotlib.org/stable/api/markers_api.html for options)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *o*  
    **s** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Marker size  
    &nbsp;&nbsp;&nbsp;&nbsp;Set marker size  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dot color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of dots  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **rgbcolumn** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;RGB column  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with RGB values defining the colors of the dots of the scatterplot  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **bins** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;2D bins  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of bins in x and y dimension. Density is expressed as the number of points falling within the x and y boundaries of a bin.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30,30*  
    **density_colormap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Density plot color map  
    &nbsp;&nbsp;&nbsp;&nbsp;Select the color map to be used for the density scatter plot  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *viridis, plasma, inferno, magma, cividis, Greys, Purples, Blues, Greens, Oranges, Reds, YlOrBr, YlOrRd, OrRd, PuRd, RdPu, BuPu, GnBu, PuBu, YlGnBu, PuBuGn, BuGn, YlGn*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *viridis*  
    **trendline** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *linear,  polynomial*  
    **degree** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Degree  
    &nbsp;&nbsp;&nbsp;&nbsp;Degree polynomial trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **line_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *darkgrey*  
    **line_style** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line style trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Line style trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *--*  
    **line_width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;trendline width  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width of the trendline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **n** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;standard deviations  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw the covariance confidence ellipse(s) with radius of n standard deviations.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **ellipse_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ellipse color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the ellipse  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *red*  
    **ellipse_alpha** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Opacity ellipse fill.  
    &nbsp;&nbsp;&nbsp;&nbsp;Opacity of the fill color of the ellipse.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **ellipse_edge_style** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ellipse edge style  
    &nbsp;&nbsp;&nbsp;&nbsp;Line style of the ellipse  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **ellipse_edge_width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ellipse edge width  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of the ellipse edge  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **groups** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column grouping the features in categories  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with categories. If selected, a separate ellipse will be drawn for each group/category  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **groups_rgb** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;RGB column for ellipse categories  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with RGB values per category. These will be used to define the color of the ellipse.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **ellipse_legend** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;legend for ellipses  
    &nbsp;&nbsp;&nbsp;&nbsp;Print the legend for the ellipses (only for if ellipses for groups are drawn)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *yes, no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yes*  
    **quadrants** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;quadrants  
    &nbsp;&nbsp;&nbsp;&nbsp;Print the mean or median on x and y-axis  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mean, median*  
    **quandrant_linecolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the lines making up the quadrants  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *grey*  
    **quandrant_linewidth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;quandrant line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width of the lines dividing the points in four quadrants  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **x_axis_limits** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;X axis range (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the X axis range to be displayed  
    **y_axis_limits** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Y axis range (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the Y axis range to be displayed  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *e*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse color map  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw a covariance confidence ellipse(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add grid lines  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.scatterplot* draws a scatterplot of the value in one column against
the values in another column. There are a few layout options, including
the option to set the color of the dots, the color, line type, and width
of the trend line, and the font size of the axis and tic labels.

Instead of a fixed color, dots can be colored using colors from a
user-defined column, or by the spatial density of nearby points, using
the option `type=density`. The spatial density is computed by grouping
the points in 2D bins. The number of bins along the x-axis and y-axis is
user-defined. The user can select a color map from a list of sequential
colormaps and perceptually uniform sequential colormaps. See the
matplotlib [manual
page](https://matplotlib.org/stable/users/explain/colors/colormaps.html)
for details. Use the **-r** flag to reverse the order of the colors.

By default, the resulting plot is displayed on screen (default).
However, the user can also save the plot to a file using the
**file\_name** option. The format is determined by the extension given
by the user. So, if `file_name = outputfile.png`, the plot will be saved
as a PNG file.

A linear or polynomial trend line with user-defined degrees can be drawn
on top of the scatter/density plot. If this option is enables, the R2
and trend line equation are printed to the commmand line.

A confidence ellipse of the covariance of the two variables can be
plotted on top of the scatterplot, following the method described in
[Plot Confidence Ellipse 001](https://carstenschelp.github.io/2018/09/14/Plot_Confidence_Ellipse_001.html),
and using the code described in the Matplotlib example
[confidence_ellipse](https://matplotlib.org/stable/gallery/statistics/confidence_ellipse.html).
The radius of the ellipse can be controlled by **n** which is the number
of standard deviations (SD). The default is 2 SD, which results in an
ellipse that encloses around 95% of the points. Optionally, separate
confidence ellipses can be drawn for groups defined in the column
**groups**. Groups can be assigned a random color, or a color based on
the RGB colors in a user-defined column. Note, all records in the group
should have the same color.

The user has the option to limit/expand the X-axis (**x\_axis\_limits**)
and Y-axis (**y\_axis\_limits**). This can e.g., make it easier to
compare different plots.

## EXAMPLES

### Example 1

For the examples below, the NCA sample data set from [GRASS GIS
website](https://grass.osgeo.org/download/data/) will be used

Create a new mapset and Use the layer *lsat7\_2002\_10@PERMANENT* to set
the region.

```sh
g.mapset -c mapset=scatterplot
g.region raster=lsat7_2002_10@PERMANENT
```

Get the list of Landsat layers from the Permanent mapset. Use this as
input for *i.pca* to create principal component layers.

```sh
lcc=`g.list type="raster" mapset="PERMANENT" pattern="lsat7_*" sep=,`
i.pca -n input=$lcc output=pca rescale=0,100
```

Create 5000 random points, retrieve the raster value from the first two
PCA layers for each point location of the random points, and write these
values to the columns *pca\_1* and *pca\_2* in the attribute table of
*randompoints*.

```sh
r.random input=elevation npoints=5000 vector=randompoints seed=10
v.what.rast map=randompoints raster=pca.1 column=pca_1
v.what.rast map=randompoints raster=pca.2 column=pca_2
```

Create a scatterplot, plotting the values from the column *pca\_1* on
the X-axis and *pca\_2* on the Y-asix, with blue dots.

```sh
v.scatterplot map=randompoints x=pca_1 y=pca_2 color=blue
```

[![image-alt](v_scatterplot_01.png)](v_scatterplot_01.png)  
*Figure 1. Scatterplot of pca\_1 against pca\_2.*

### Example 2

Create a density scatter of the values from *pca\_1* and *pca\_2*. Add a
red dashed polynomial trend line with degree 2.

```sh
v.scatterplot map=randompoints x=pca_1 y=pca_2 trendline=polynomial \
              degree=2 line_color=red type=density bins=10,10
```

[![image-alt](v_scatterplot_02.png)](v_scatterplot_02.png)  
*Figure 2. Density scatterplot of pca\_1 against pca\_2. The dashed red
line gives the polynomial trend line (R²=0.149)*

### Example 3

Retrieves raster value from the raster layer *landclass96*, and write
these values to the column *landuse* in the attribute table of
*randompoints*. Next, transfer the raster colors of the raster layer
*landclass96* to the new column *RGB* of the attribute table of
*randompoints*.

```sh
v.what.rast map=randompoints raster=landclass96 column=landuse
v.colors map=randompoints use=attr column=landuse \
         raster=landclass96@PERMANENT rgb_column=RGB
```

Create a scatterplot, using the colors from the RGB column. Set the size
of the dots to 8.

```sh
v.scatterplot map=randompoints x=pca_1 y=pca_2 s=8 rgbcolumn=RGB
```

[![image-alt](v_scatterplot_03.png)](v_scatterplot_03.png)  
*Figure 3. Scatterplot of pca\_1 against pca\_1. Colors represent the
land use categories in the point locations based on the landclass96
map.*

### Example 4

Rename the PCA layers to remove the dots from the name. Next, use the
[v.what.rast.label](https://grass.osgeo.org/grass-stable/manuals/addons/v.what.rast.label.html)
addon to sample the values of the raster layers *pca.1* and *pca.2*, and
the values + labels of the *landclass96*. Add a column with the
landclass colors using *v.colors*.

```sh
g.rename raster=pca.1,pca_1
g.rename raster=pca.2,pca_2
v.what.rast.label vector=randompoints raster=landclass96 \
         raster2=pca_1,pca_2 output=randompoints2
v.colors map=randompoints2 use=attr column=landclass96_ID \
         raster=landclass96 rgb_column=RGB
```

Extract the points with the categories forest (5), water (6) and
developed (1). Create a scatterplot of pca\_1 against pca\_2 and add the
2 SD confidence ellipse of the covariance of the two variables for each
of the land use categories, coloring both the dots and ellipses using
the landclass colors.

```sh
v.extract input=randompoints2 \
          where='landclass96_ID=1 OR landclass96_ID=5 OR landclass96_ID=6' \
          output=forwatdev
v.scatterplot -e map=forwatdev x=pca_1 y=pca_2 rgbcolumn=RGB s=5  \
              groups=landclass96 groups_rgb=RGB
```

[![image-alt](v_scatterplot_04.png)](v_scatterplot_04.png)  
*Figure 4. Scatterplot with confidence ellipses per land class. The
radius of the ellipses is 2 SD.*

## SEE ALSO

*[d.vect.colbp](https://grass.osgeo.org/grass-stable/manuals/addons/d.vect.colbp.html),
[d.vect.colhist](https://grass.osgeo.org/grass-stable/manuals/addons/d.vect.colhist.html),
[r.boxplot](https://grass.osgeo.org/grass-stable/manuals/addons/r.boxplot.html),
[r.series.boxplot](https://grass.osgeo.org/grass-stable/manuals/addons/r.series.boxplot.html),
[t.rast.boxplot](https://grass.osgeo.org/grass-stable/manuals/addons/t.rast.boxplot.html),
[r.scatterplot](https://grass.osgeo.org/grass-stable/manuals/addons/r.scatterplot.html)
[r3.scatterplot](https://grass.osgeo.org/grass-stable/manuals/addons/r3.scatterplot.html)*

## AUTHOR

Paulo van Breugel Applied Geo-information Sciences HAS green academy,
University of Applied Sciences

## SOURCE CODE

Available at: [v.scatterplot source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.scatterplot)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.scatterplot))  
Latest change: Thursday May 29 11:23:19 2025 in commit [701c59b](https://github.com/OSGeo/grass-addons/commit/701c59b932c6a12e06ba3a4135cab5955cd9047a)
