---
name: v.stream.inbasin.py
description: Subset a stream network into just one of its basins
keywords: [ vector, stream network, basins, hydrology, geomorphology ]
---

# v.stream.inbasin.py

Subset a stream network into just one of its basins

=== "Command line"

    **v.stream.inbasin.py**
    [**-s**]
    **input_streams**=*name*
    [**input_basins**=*name*]
    [**draindir**=*name*]
    [**cat**=*string*]
    [**coordinates**=*east,north*]
    [**output_basin**=*name*]
    [**output_streams**=*name*]
    [**output_pour_point**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.stream.inbasin.py input_streams=name coordinates=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.stream.inbasin.py***",
        **input_streams**,
        **input_basins**=*None*,
        **draindir**=*None*,
        **cat**=*None*,
        **coordinates**=*None*,
        **output_basin**=*None*,
        **output_streams**=*None*,
        **output_pour_point**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.stream.inbasin.py", input_streams="name", coordinates=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_stream_inbasin_py*(**input_streams**,
        **input_basins**=*None*,
        **draindir**=*None*,
        **cat**=*None*,
        **coordinates**=*None*,
        **output_basin**=*None*,
        **output_streams**=*None*,
        **output_pour_point**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_stream_inbasin_py(input_streams="name", coordinates=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input_streams**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream network  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **input_basins**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subbasins built alongside stream network  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **draindir**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Drainage directions (needed if exact coordinates used)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **cat**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Farthest downstream segment category  
    **coordinates**=*east,north*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pour point coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;The alogorithm will find the closest stream segment  
    **output_basin**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector output drainage basin  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **output_streams**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streams within vector output drainage basin  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **output_pour_point**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basin outlet  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Snap provided coordinates to nearest segment endpoint  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input_streams** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream network  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **input_basins** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subbasins built alongside stream network  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **draindir** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Drainage directions (needed if exact coordinates used)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cat** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Farthest downstream segment category  
    **coordinates** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pour point coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;The alogorithm will find the closest stream segment  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **output_basin** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector output drainage basin  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **output_streams** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streams within vector output drainage basin  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **output_pour_point** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basin outlet  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Snap provided coordinates to nearest segment endpoint  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input_streams** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream network  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **input_basins** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subbasins built alongside stream network  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **draindir** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Drainage directions (needed if exact coordinates used)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cat** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Farthest downstream segment category  
    **coordinates** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pour point coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;The alogorithm will find the closest stream segment  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **output_basin** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector output drainage basin  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **output_streams** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streams within vector output drainage basin  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **output_pour_point** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basin outlet  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Snap provided coordinates to nearest segment endpoint  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.stream.inbasin* uses the output of *v.stream.network* to select only
those streams (and sub-basins) that are upstream of (and inclusive of) a
selected link in the network. It is used as a step to develop GSFLOW
model inputs for a watershed, but need not be exclusively used for that
purpose. *v.stream.inbasin* expects the stream network attributes
created by *v.stream.network* and named using the names
*v.stream.network* uses by default. In other words, *v.stream.inbasin*
will work on the output *v.stream.network* with default attribute names.

## REFERENCES

- Ng, G.-H. C., A. D. Wickert, R. L. McLaughlin, J. La Frenierre, S.
    Liess, and L. Sabeeri (2016), Modeling the role of groundwater and
    vegetation in the hydrological response of tropical glaciated
    watersheds to climate change, in AGU Fall Meeting Abstracts,
    H13L–1590, San Francisco, CA.
- Ng, G-H. Crystal, Andrew D. Wickert, Lauren D. Somers, Leila Saberi,
    Collin Cronkite-Ratcliff, Richard G. Niswonger, and Jeffrey M.
    McKenzie. "GSFLOW–GRASS v1. 0.0: GIS-enabled hydrologic modeling of
    coupled groundwater–surface-water systems." *Geoscientific Model
    Development* 11 (2018): 4755-4777.
    [DOI 10.5194/gmd-11-4755-2018](https://doi.org/10.5194/gmd-11-4755-2018)

## SEE ALSO

*[v.gsflow.hruparams](v.gsflow.hruparams.md),
[v.gsflow.segments](v.gsflow.segments.md),
[v.stream.network](v.stream.network.md)*

## AUTHOR

Andrew D. Wickert

## SOURCE CODE

Available at: [v.stream.inbasin source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.stream.inbasin)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.stream.inbasin))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
