---
name: v.to.rast.multi.py
description: Create raster maps for multiple numeric attribute columns of a vector map
keywords: [ vector, conversion, raster, rasterization, reclassify, multiple ]
---

# v.to.rast.multi.py

Create raster maps for multiple numeric attribute columns of a vector map

=== "Command line"

    **v.to.rast.multi.py**
    [**-d**]
    **input**=*name*
    [**layer**=*string*]
    [**type**=*string* [,*string*,...]]
    [**cats**=*range*]
    [**where**=*sql_query*]
    **output**=*prefix*
    **key_column**=*name*
    **attribute_columns**=*names* [,*names*,...]
    [**label_columns**=*names* [,*names*,...]]
    [**memory**=*memory in MB*]
    [**ndigits**=*number of digits* [,*number of digits*,...]]
    [**separator**=*Separator*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.to.rast.multi.py input=name output=prefix key_column=cat attribute_columns=names
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.to.rast.multi.py***",
        **input**,
        **layer**=*"1"*,
        **type**=*"point,line,area"*,
        **cats**=*None*,
        **where**=*None*,
        **output**,
        **key_column**=*"cat"*,
        **attribute_columns**,
        **label_columns**=*None*,
        **memory**=*300*,
        **ndigits**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.to.rast.multi.py", input="name", output="prefix", key_column="cat", attribute_columns="names")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_to_rast_multi_py*(**input**,
        **layer**=*"1"*,
        **type**=*"point,line,area"*,
        **cats**=*None*,
        **where**=*None*,
        **output**,
        **key_column**=*"cat"*,
        **attribute_columns**,
        **label_columns**=*None*,
        **memory**=*300*,
        **ndigits**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_to_rast_multi_py(input="name", output="prefix", key_column="cat", attribute_columns="names")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **cats**=*range*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **output**=*prefix* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for output raster maps  
    **key_column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the key column (default: cat, data type must be integer)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cat*  
    **attribute_columns**=*names* [,*names*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of columns for 'attr' parameter (data type must be numeric)  
    **label_columns**=*names* [,*names*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of columns used as raster category labels  
    **memory**=*memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **ndigits**=*number of digits* [,*number of digits*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits per attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits per attribute column (for columns with floating point data)  
    **separator**=*Separator*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used for parsing attribute table (it should not occur in any selected column)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create densified lines (default: thin lines)  
    &nbsp;&nbsp;&nbsp;&nbsp;All cells touched by the line will be set, not only those on the render path  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *prefix*  
    **key_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the key column (default: cat, data type must be integer)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cat*  
    **attribute_columns** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of columns for 'attr' parameter (data type must be numeric)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *names*  
    **label_columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of columns used as raster category labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *names*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **ndigits** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits per attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits per attribute column (for columns with floating point data)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *number of digits*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used for parsing attribute table (it should not occur in any selected column)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *Separator*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create densified lines (default: thin lines)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;All cells touched by the line will be set, not only those on the render path  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *prefix*  
    **key_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the key column (default: cat, data type must be integer)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cat*  
    **attribute_columns** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of columns for 'attr' parameter (data type must be numeric)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *names*  
    **label_columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of columns used as raster category labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *names*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **ndigits** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits per attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits per attribute column (for columns with floating point data)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *number of digits*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used for parsing attribute table (it should not occur in any selected column)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *Separator*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create densified lines (default: thin lines)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;All cells touched by the line will be set, not only those on the render path  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.to.rast.multi* creates a raster map for each selected numeric column
of the attribute table of a vector map. The purpose is to provide a
simple and efficient way to rasterize different attributes of vector
maps with multiple numeric value columns.

It is a simple wrapper around *v.to.rast* and most of the options from
that module are available. *v.to.rast.multi* works as follows: First,
(only) the key column is rasterized with *v.to.rast*. Then
reclassification rules are generated for all selected attribute columns
and the **key\_column** and reclass maps are created with *r.reclass*.

Because *r.relass* only handles integer data and rounds data with
floating point precision, the number of significant digits to preserve
during reclassification can be defined with the **ndigits** option. Also
text labels can be provided in the **label\_columns** option.

If the **label\_columns** or **ndigits** are given, the number and order
of provided values has to correspond to the number and order of the
selected **attribute\_columns**.

## EXAMPLE

This example is based on the North Carolina sample location
(nc\_spm\_08\_grass7) which can be downloaded from the [GRASS GIS
website](https://grass.osgeo.org/download/data/).

```sh
# Create raster maps for RINGS_OK amd TRACT attribute of the census_wake2000 map
# Note: RINGS_OK is of type integer, so 0 digits need to be preserved
v.to.rast.multi --o --v input=census_wake2000 type=area \
output=vrastmulti attribute_columns="RINGS_OK,TRACT" \
label_columns="ID,TRACTID" memory=3000 ndigits="0,4" separator=","
```

## SEE ALSO

*[v.to.rast](https://grass.osgeo.org/grass-stable/manuals/v.to.rast.html),
[r.reclass](https://grass.osgeo.org/grass-stable/manuals/v.what.strds.html)*

## AUTHOR

Stefan Blumentrath, Norwegian Institute for Nature Research (NINA)

## SOURCE CODE

Available at: [v.to.rast.multi source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.to.rast.multi)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.to.rast.multi))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
