---
name: v.vect.stats.multi.py
description: Computes isochrones from collection point in a sewershed
keywords: [ vector, attribute table, statistics, univariate statistics, zonal statistics, columns ]
---

# v.vect.stats.multi.py

Computes isochrones from collection point in a sewershed

=== "Command line"

    **v.vect.stats.multi.py**
    **points**=*name*
    **areas**=*name*
    [**type**=*string* [,*string*,...]]
    [**points_layer**=*string*]
    [**points_cats**=*range*]
    [**points_where**=*sql_query*]
    [**areas_layer**=*string*]
    [**areas_cats**=*range*]
    [**areas_where**=*sql_query*]
    **method**=*string* [,*string*,...]
    [**points_columns**=*name* [,*name*,...]]
    **count_column**=*name*
    [**stats_columns**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.vect.stats.multi.py points=name areas=name method=sum count_column=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.vect.stats.multi.py***",
        **points**,
        **areas**,
        **type**=*"point"*,
        **points_layer**=*"1"*,
        **points_cats**=*None*,
        **points_where**=*None*,
        **areas_layer**=*"1"*,
        **areas_cats**=*None*,
        **areas_where**=*None*,
        **method**,
        **points_columns**=*None*,
        **count_column**,
        **stats_columns**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.vect.stats.multi.py", points="name", areas="name", method="sum", count_column="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_vect_stats_multi_py*(**points**,
        **areas**,
        **type**=*"point"*,
        **points_layer**=*"1"*,
        **points_cats**=*None*,
        **points_where**=*None*,
        **areas_layer**=*"1"*,
        **areas_cats**=*None*,
        **areas_where**=*None*,
        **method**,
        **points_columns**=*None*,
        **count_column**,
        **stats_columns**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_vect_stats_multi_py(points="name", areas="name", method="sum", count_column="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **points**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing vector map with points  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with one or more attributes  
    **areas**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing vector map with points  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with one or more attributes  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point*  
    **points_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number for points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **points_cats**=*range*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values for points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **points_where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword for points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **areas_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number for area map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **areas_cats**=*range*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values for area map  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **areas_where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword for area map  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **method**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for aggregate statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sum, average, median, mode, minimum, maximum, range, stddev, variance, diversity*  
    **points_columns**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Column names of points map to compute statistics from  
    &nbsp;&nbsp;&nbsp;&nbsp;Defaults to all numeric columns. The specified columns must be numeric  
    **count_column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name to upload points count  
    &nbsp;&nbsp;&nbsp;&nbsp;Column to hold points count, must be of type integer, will be created if not existing  
    **stats_columns**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column names to upload statistics (generated by default)  
    &nbsp;&nbsp;&nbsp;&nbsp;By default, generated as source column name underscore method name  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **points** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing vector map with points  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with one or more attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **areas** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing vector map with points  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with one or more attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point*  
    **points_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number for points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **points_cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values for points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **points_where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword for points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **areas_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number for area map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **areas_cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values for area map  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **areas_where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword for area map  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **method** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for aggregate statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sum, average, median, mode, minimum, maximum, range, stddev, variance, diversity*  
    **points_columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column names of points map to compute statistics from  
    &nbsp;&nbsp;&nbsp;&nbsp;Defaults to all numeric columns. The specified columns must be numeric  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **count_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name to upload points count  
    &nbsp;&nbsp;&nbsp;&nbsp;Column to hold points count, must be of type integer, will be created if not existing  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **stats_columns** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column names to upload statistics (generated by default)  
    &nbsp;&nbsp;&nbsp;&nbsp;By default, generated as source column name underscore method name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **points** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing vector map with points  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with one or more attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **areas** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing vector map with points  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with one or more attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point*  
    **points_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number for points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **points_cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values for points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **points_where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword for points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **areas_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number for area map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **areas_cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values for area map  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **areas_where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword for area map  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **method** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for aggregate statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sum, average, median, mode, minimum, maximum, range, stddev, variance, diversity*  
    **points_columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column names of points map to compute statistics from  
    &nbsp;&nbsp;&nbsp;&nbsp;Defaults to all numeric columns. The specified columns must be numeric  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **count_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name to upload points count  
    &nbsp;&nbsp;&nbsp;&nbsp;Column to hold points count, must be of type integer, will be created if not existing  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **stats_columns** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column names to upload statistics (generated by default)  
    &nbsp;&nbsp;&nbsp;&nbsp;By default, generated as source column name underscore method name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.vect.stats.multi* computes attribute statistics of points in vector
map *points* falling into each area in vector map *areas*. The results
are uploaded to the attribute table of the vector map *areas*.

By default, statistics are computed for all integer and floating point
attributes (columns), e.g., DOUBLE PRECISION and INTEGER columns will be
used, but TEXT will not. Specific (multiple) columns can be selected
using **points\_columns**. The type of the selected columns again need
to be some integer and floating point type.

### Statistical methods

Using numeric attribute values of all points falling into a given area,
a new value is determined with the selected method.

*v.vect.stats* can perform the following operations:

- **sum**  
    The sum of values.
- **average**  
    The average value of all point attributes (sum / count).
- **median**  
    The value found half-way through a list of the attribute values,
    when these are ranged in numerical order.
- **mode**  
    The most frequently occurring value.
- **minimum**  
    The minimum observed value.
- **maximum**  
    The maximum observed value.
- **range**  
    The range of the observed values.
- **stddev**  
    The statistical standard deviation of the attribute values.
- **variance**  
    The statistical variance of the attribute values.
- **diversity**  
    The number of different attribute values.

The count (number of points) is always computed and stored in
**count\_column**.

### Column names

The **stats\_columns** can be used to provide custom column names
instead of the generated ones. If provided, the number of columns must
be number of **points\_columns** times number of methods requested (in
**method**). The order of names is that first come all statistics for
one column, then all statistics for another column, etc. If only one
statistical method is requested, then it is simply one column from
**points\_columns** after another. Note that the number of names
**stats\_columns** is checked against the number of columns that will be
created. However, whether the names correspond to what is being computed
for the columns cannot be checked, so, for example, providing names for
one statistic for all columns, followed by another statistic, etc. will
result in a mismatch between column names and what was actually
computed.

## NOTES

This module is using
*[v.vect.stats](https://grass.osgeo.org/grass-stable/manuals/v.vect.stats.html)*
underneath to do the actual statistical computations. See *v.vect.stats*
for details about behavior in special cases.

## EXAMPLES

### ZIP codes and POIs

The following example is using points of interest (POIs) and ZIP code
areas vector from the basic North Carolina sample database: Create a
copy of ZIP code areas in the current mapset to allow for adding
attributes (using a name which expresses what you will add later on):

```sh
g.copy vector=zipcodes@PERMANENT,zipcodes_with_poi_stats
```

Compute minimum and maximum for each numerical colum in the attribute
table of points of interest:

```sh
v.vect.stats.multi points=points_of_interest areas=zipcodes_with_poi_stats method=minimum,maximum count_column=point_count
```

Use *v.info* to see all the newly created columns:

```sh
v.info -c map=zipcodes_with_poi_stats
```

Use *v.db.select* (or GUI) to examine the values (you can see subset of
the data by selecting only specific columns or using the where cause to
get only certain rows):

```sh
v.db.select map=zipcodes_with_poi_stats
```

Each of the new columns separately can be assigned color using
*v.colors*:

```sh
v.colors map=zipcodes_with_poi_stats use=attr column=elev_m_maximum color=viridis rgb_column=elev_m_maximum_color
```

### Specifying columns by name

Assuming a similar setup as in the previous example (*g.copy* used to
create a copy in the current mapset), you can ask for statistics only on
columns PUMPERS, TANKER, and AERIAL and specify the names of new columns
using: (wrapping a long line here using Bash-like syntax):

```sh
v.vect.stats.multi points=firestations areas=zipcodes method=sum \
    count_column=count point_columns=PUMPERS,TANKER,AERIAL \
    stats_columns=all_pumpers,all_tankers,all_aerials
```

## SEE ALSO

- *[v.vect.stats](https://grass.osgeo.org/grass-stable/manuals/v.vect.stats.html)*
    for printing information instead of storing it in the attribute
    table,
- *[v.what.rast.multi](v.what.rast.multi.md)* for querying multiple
    raster maps by one vector points map,
- *[g.copy](g.copy.md)* for creating a copy of vector map to update
    (to preserve the original data given that this module performs a
    large automated operation).

## AUTHOR

Vaclav Petras, [NCSU Center for Geospatial
Analytics](https://cnr.ncsu.edu/geospatial)

## SOURCE CODE

Available at: [v.vect.stats.multi source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.vect.stats.multi)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.vect.stats.multi))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
