---
name: d.barscale
description: Displays a barscale on the graphics monitor.
keywords: [ display, cartography ]
---

# d.barscale

Displays a barscale on the graphics monitor.

=== "Command line"

    **d.barscale**
    [**-ftn**]
    [**style**=*string*]
    [**at**=*x,y*]
    [**length**=*integer*]
    [**units**=*string*]
    [**label**=*string*]
    [**segment**=*integer*]
    [**color**=*name*]
    [**bgcolor**=*name*]
    [**text_position**=*string*]
    [**width_scale**=*float*]
    [**font**=*string*]
    [**fontsize**=*float*]
    [**path**=*name*]
    [**charset**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.barscale
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.barscale***",
        **style**=*"classic"*,
        **at**=*"0.0,10.0"*,
        **length**=*0*,
        **units**=*None*,
        **label**=*None*,
        **segment**=*10*,
        **color**=*"black"*,
        **bgcolor**=*"white"*,
        **text_position**=*"right"*,
        **width_scale**=*1*,
        **font**=*None*,
        **fontsize**=*12*,
        **path**=*None*,
        **charset**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.barscale")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_barscale*(**style**=*"classic"*,
        **at**=*"0.0,10.0"*,
        **length**=*0*,
        **units**=*None*,
        **label**=*None*,
        **segment**=*10*,
        **color**=*"black"*,
        **bgcolor**=*"white"*,
        **text_position**=*"right"*,
        **width_scale**=*1*,
        **font**=*None*,
        **fontsize**=*12*,
        **path**=*None*,
        **charset**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_barscale()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **style**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of barscale to draw  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *classic, line, solid, hollow, full_checker, part_checker, mixed_checker, tail_checker, up_ticks, down_ticks, both_ticks, arrow_ends*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *classic*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![classic](barscales/classic.png) &nbsp;&nbsp;&nbsp;&nbsp;**classic**: Classic style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![line](barscales/line.png) &nbsp;&nbsp;&nbsp;&nbsp;**line**: Line style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![solid](barscales/solid.png) &nbsp;&nbsp;&nbsp;&nbsp;**solid**: Solid style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![hollow](barscales/hollow.png) &nbsp;&nbsp;&nbsp;&nbsp;**hollow**: Hollow style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![full_checker](barscales/full_checker.png) &nbsp;&nbsp;&nbsp;&nbsp;**full_checker**: Full checker style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![part_checker](barscales/part_checker.png) &nbsp;&nbsp;&nbsp;&nbsp;**part_checker**: Part checker style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![mixed_checker](barscales/mixed_checker.png) &nbsp;&nbsp;&nbsp;&nbsp;**mixed_checker**: Mixed checker style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![tail_checker](barscales/tail_checker.png) &nbsp;&nbsp;&nbsp;&nbsp;**tail_checker**: Tail checker style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![up_ticks](barscales/up_ticks.png) &nbsp;&nbsp;&nbsp;&nbsp;**up_ticks**: Up ticks style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![down_ticks](barscales/down_ticks.png) &nbsp;&nbsp;&nbsp;&nbsp;**down_ticks**: Down ticks style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![both_ticks](barscales/both_ticks.png) &nbsp;&nbsp;&nbsp;&nbsp;**both_ticks**: Both ticks style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![arrow_ends](barscales/arrow_ends.png) &nbsp;&nbsp;&nbsp;&nbsp;**arrow_ends**: Arrow ends style  
    **at**=*x,y*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen coordinates of the rectangle's top-left corner  
    &nbsp;&nbsp;&nbsp;&nbsp;(0,0) is lower-left of the display frame  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0,10.0*  
    **length**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of barscale in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **units**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Barscale units to display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *meters,  kilometers,  feet,  miles*  
    **label**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Custom label of unit  
    **segment**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of segments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bar scale and text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **bgcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color (drawn behind the bar)  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **text_position**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text position  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *under, over, left, right*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *right*  
    **width_scale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor to change bar width  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.5-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **font**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **fontsize**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **path**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to font file  
    **charset**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding (only applicable to TrueType fonts)  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use feet/miles instead of meters  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw the scale bar without text  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display north-arrow symbol.  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **style** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of barscale to draw  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, barscale  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *classic, line, solid, hollow, full_checker, part_checker, mixed_checker, tail_checker, up_ticks, down_ticks, both_ticks, arrow_ends*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![classic](barscales/classic.png) &nbsp;&nbsp;&nbsp;&nbsp;**classic**: Classic style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![line](barscales/line.png) &nbsp;&nbsp;&nbsp;&nbsp;**line**: Line style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![solid](barscales/solid.png) &nbsp;&nbsp;&nbsp;&nbsp;**solid**: Solid style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![hollow](barscales/hollow.png) &nbsp;&nbsp;&nbsp;&nbsp;**hollow**: Hollow style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![full_checker](barscales/full_checker.png) &nbsp;&nbsp;&nbsp;&nbsp;**full_checker**: Full checker style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![part_checker](barscales/part_checker.png) &nbsp;&nbsp;&nbsp;&nbsp;**part_checker**: Part checker style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![mixed_checker](barscales/mixed_checker.png) &nbsp;&nbsp;&nbsp;&nbsp;**mixed_checker**: Mixed checker style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![tail_checker](barscales/tail_checker.png) &nbsp;&nbsp;&nbsp;&nbsp;**tail_checker**: Tail checker style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![up_ticks](barscales/up_ticks.png) &nbsp;&nbsp;&nbsp;&nbsp;**up_ticks**: Up ticks style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![down_ticks](barscales/down_ticks.png) &nbsp;&nbsp;&nbsp;&nbsp;**down_ticks**: Down ticks style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![both_ticks](barscales/both_ticks.png) &nbsp;&nbsp;&nbsp;&nbsp;**both_ticks**: Both ticks style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![arrow_ends](barscales/arrow_ends.png) &nbsp;&nbsp;&nbsp;&nbsp;**arrow_ends**: Arrow ends style  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *classic*  
    **at** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen coordinates of the rectangle's top-left corner  
    &nbsp;&nbsp;&nbsp;&nbsp;(0,0) is lower-left of the display frame  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0,10.0*  
    **length** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of barscale in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Barscale units to display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *meters,  kilometers,  feet,  miles*  
    **label** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Custom label of unit  
    **segment** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of segments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bar scale and text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color (drawn behind the bar)  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **text_position** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text position  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *under, over, left, right*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *right*  
    **width_scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor to change bar width  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.5-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **fontsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to font file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **charset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding (only applicable to TrueType fonts)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *t*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use feet/miles instead of meters  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw the scale bar without text  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display north-arrow symbol.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **style** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of barscale to draw  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, barscale  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *classic, line, solid, hollow, full_checker, part_checker, mixed_checker, tail_checker, up_ticks, down_ticks, both_ticks, arrow_ends*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![classic](barscales/classic.png) &nbsp;&nbsp;&nbsp;&nbsp;**classic**: Classic style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![line](barscales/line.png) &nbsp;&nbsp;&nbsp;&nbsp;**line**: Line style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![solid](barscales/solid.png) &nbsp;&nbsp;&nbsp;&nbsp;**solid**: Solid style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![hollow](barscales/hollow.png) &nbsp;&nbsp;&nbsp;&nbsp;**hollow**: Hollow style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![full_checker](barscales/full_checker.png) &nbsp;&nbsp;&nbsp;&nbsp;**full_checker**: Full checker style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![part_checker](barscales/part_checker.png) &nbsp;&nbsp;&nbsp;&nbsp;**part_checker**: Part checker style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![mixed_checker](barscales/mixed_checker.png) &nbsp;&nbsp;&nbsp;&nbsp;**mixed_checker**: Mixed checker style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![tail_checker](barscales/tail_checker.png) &nbsp;&nbsp;&nbsp;&nbsp;**tail_checker**: Tail checker style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![up_ticks](barscales/up_ticks.png) &nbsp;&nbsp;&nbsp;&nbsp;**up_ticks**: Up ticks style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![down_ticks](barscales/down_ticks.png) &nbsp;&nbsp;&nbsp;&nbsp;**down_ticks**: Down ticks style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![both_ticks](barscales/both_ticks.png) &nbsp;&nbsp;&nbsp;&nbsp;**both_ticks**: Both ticks style  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![arrow_ends](barscales/arrow_ends.png) &nbsp;&nbsp;&nbsp;&nbsp;**arrow_ends**: Arrow ends style  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *classic*  
    **at** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen coordinates of the rectangle's top-left corner  
    &nbsp;&nbsp;&nbsp;&nbsp;(0,0) is lower-left of the display frame  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0,10.0*  
    **length** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of barscale in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Barscale units to display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *meters,  kilometers,  feet,  miles*  
    **label** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Custom label of unit  
    **segment** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of segments  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bar scale and text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color (drawn behind the bar)  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **text_position** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text position  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *under, over, left, right*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *right*  
    **width_scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor to change bar width  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.5-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **fontsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to font file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **charset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding (only applicable to TrueType fonts)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *t*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use feet/miles instead of meters  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw the scale bar without text  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display north-arrow symbol.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.barscale* displays a barscale on the graphics monitor at the given
screen coordinates. If no coordinates are given it will draw the
barscale in the bottom left of the display.

The barscale can drawn in a number of styles (see **style** parameter
for their previews).

## NOTE

*d.barscale* will not work with Lat/Lon coordinate reference system as
the horizontal scale distance changes with latitude. Try
*[d.grid](d.grid.md)* instead.

## SEE ALSO

*[d.graph](d.graph.md), [d.grid](d.grid.md), [d.legend](d.legend.md),
[d.northarrow](d.northarrow.md), [g.region](g.region.md)*

## AUTHORS

Unknown, from USACE/CERL.  
Major rewrite for GRASS 7 by Hamish Bowman

## SOURCE CODE

Available at: [d.barscale source code](https://github.com/OSGeo/grass/tree/main/display/d.barscale)
([history](https://github.com/OSGeo/grass/commits/main/display/d.barscale))  
Latest change: Thursday May 08 14:17:52 2025 in commit [3caa352](https://github.com/OSGeo/grass/commit/3caa352f78f86a51ca463a6f1ba7ffe3db9771df)
