---
name: d.out.file.py
description: Saves the contents of the active display monitor to a graphics file.
keywords: [ display, export, output ]
---

# d.out.file.py

Saves the contents of the active display monitor to a graphics file.

=== "Command line"

    **d.out.file.py**
    **output**=*name*
    **format**=*string*
    [**size**=*width,height*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.out.file.py output=name format=png
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.out.file.py***",
        **output**,
        **format**=*"png"*,
        **size**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.out.file.py", output="name", format="png")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_out_file_py*(**output**,
        **format**=*"png"*,
        **size**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_out_file_py(output="name", format="png")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **format**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Graphics file format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *png, jpg, bmp, gif, tif*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *png*  
    **size**=*width,height*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width and height of output image  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Graphics file format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *png, jpg, bmp, gif, tif*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *png*  
    **size** : tuple[int, int] | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width and height of output image  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *width,height*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Graphics file format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *png, jpg, bmp, gif, tif*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *png*  
    **size** : tuple[int, int] | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width and height of output image  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *width,height*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.out.file* saves the content of the currently selected monitor into
graphic file. The active monitor can be selected with *d.mon*.
*d.out.file* can be run from GUI Console tab, too.

## SEE ALSO

*[d.redraw](d.redraw.md), [d.erase](d.erase.md), [d.rast](d.rast.md),
[d.vect](d.vect.md), [d.mon](d.mon.md)*

## AUTHOR

Anna Petrasova, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [d.out.file source code](https://github.com/OSGeo/grass/tree/main/scripts/d.out.file)
([history](https://github.com/OSGeo/grass/commits/main/scripts/d.out.file))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
