---
name: d.polar.py
description: Draws polar diagram of angle map such as aspect or flow directions
keywords: [ display, diagram ]
---

# d.polar.py

Draws polar diagram of angle map such as aspect or flow directions

=== "Command line"

    **d.polar.py**
    [**-x**]
    **map**=*name*
    [**undef**=*float*]
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.polar.py map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.polar.py***",
        **map**,
        **undef**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.polar.py", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_polar_py*(**map**,
        **undef**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_polar_py(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster angle map  
    **undef**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pixel value to be interpreted as undefined (different from NULL)  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for optional EPS output file  
    **-x**  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot using Xgraph  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster angle map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **undef** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pixel value to be interpreted as undefined (different from NULL)  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for optional EPS output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *x*  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Plot using Xgraph  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster angle map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **undef** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pixel value to be interpreted as undefined (different from NULL)  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for optional EPS output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *x*  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Plot using Xgraph  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.polar* calculates and displays a polar diagram of an angle raster map
such as aspect, wind direction, or flow. The input angle map orientation
must be counter-clockwise (CCW) from east, and the angle map units must
be degrees. This refers to the standard orientation of GRASS (e.g., see
*r.slope.aspect*).

The radius of the outer circle is defined by the total number of pixels
in the map. If the polar diagram does not reach the outer circle, no
data (NULL) pixels were found in the map.

The vector in the diagram indicates a prevailing direction, its length
the strength of such direction. In case all angle vectors are oriented
along the same direction, the length for the vector is maximal (in fact
it is equal to length of the most populated bin of the underlying
histogram).

As a side effect, the quality of the angle map can be derived from the
diagram. Strong spikes may indicate an over-representation of the
related angle(s) which happens in particular if integer maps are used.

## NOTES

If the **output** parameter is used, the diagram is generated as EPS
file. If the **-x** flag is used *xgraph* is launched. Otherwise
*d.polar* will use *d.graph* to draw the plot in the current display
frame.

If *d.polar* is used on an aspect map generated by *r.slope.aspect*, the
**undef** parameter should be set to 0 to distinguish NO DATA (NULL)
areas from areas where aspect is undefined (i.e. flat areas).

![Polar diagram of aspect map](d_polar_aspect.png)  
*Polar diagram of aspect map*

## EXAMPLE

In this example, the polar diagram of the 'aspect' angle map in the
North Carolina sample dataset is generated:

```sh
g.region raster=aspect -p
d.polar aspect
```

## XGRAPH REQUIREMENT

[Xgraph](http://www.xgraph.org) must be installed for the **-x** flag to
function.

## SEE ALSO

*[d.graph](d.graph.md), [d.histogram](d.histogram.md),
[d.rast.arrow](d.rast.arrow.md), [r.slope.aspect](r.slope.aspect.md)*

## REFERENCES

J. Hofierka, H. Mitasova, and M. Neteler (2009): Terrain
parameterization in GRASS. In T. Hengl and H.I. Reuter, editors,
Geomorphometry: concepts, software, applications. Elsevier
([DOI](https://doi.org/10.1016/S0166-2481(08)00017-2))

## AUTHORS

Markus Neteler, ITC-irst, Italy  
Bruno Caprile, ITC-irst, Italy  
Hamish Bowman, Otago University, New Zealand

## SOURCE CODE

Available at: [d.polar source code](https://github.com/OSGeo/grass/tree/main/scripts/d.polar)
([history](https://github.com/OSGeo/grass/commits/main/scripts/d.polar))  
Latest change: Thursday Nov 06 22:27:54 2025 in commit [298b386](https://github.com/OSGeo/grass/commit/298b38614712934179355ea767403d6bfea8f5f9)
