---
name: d.rast
description: Displays user-specified raster map in the active graphics frame.
keywords: [ display, graphics, raster ]
---

# d.rast

Displays user-specified raster map in the active graphics frame.

=== "Command line"

    **d.rast**
    [**-ni**]
    **map**=*name*
    [**values**=*value[-value]* [,*value[-value]*,...]]
    [**bgcolor**=*color*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.rast map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.rast***",
        **map**,
        **values**=*None*,
        **bgcolor**=*"white"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.rast", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_rast*(**map**,
        **values**=*None*,
        **bgcolor**=*"white"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_rast(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be displayed  
    **values**=*value[-value]* [,*value[-value]*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;List of categories or values to be displayed  
    **bgcolor**=*color*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color (for null)  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Make null cells opaque  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Invert value list  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be displayed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **values** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of categories or values to be displayed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value[-value]*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color (for null)  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *color*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Make null cells opaque  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert value list  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to be displayed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **values** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of categories or values to be displayed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value[-value]*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color (for null)  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *color*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Make null cells opaque  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert value list  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.rast* displays the specified raster map in the active display frame
on the graphics monitor.

## EXAMPLE

Display raster map "elevation":

```sh
d.rast map=elevation
```

![d.rast elevation](d_rast_elevation.png)  
*Figure: elevation raster map visualization*

Display raster map "elevation" but only the raster cells with values
between 75 and 80 meters:

```sh
d.rast map=elevation values=75-80
```

![d.rast elevation with values](d_rast_elevation_values.png)  
*Figure: elevation raster map showing values between 75 and 80 meters*

Display raster map "landuse96_28m" but only categories 1 and 2:

```sh
d.rast landuse96_28m values=1,2
```

![d.rast landuse](d_rast_landuse.png)  
*Figure: landuse raster map showing categories 1 and 2*

## SEE ALSO

*[d.rast.arrow](d.rast.arrow.md), [d.rast.num](d.rast.num.md),
[d.rast.leg](d.rast.leg.md), [d.legend](d.legend.md), [d.mon](d.mon.md),
[d.erase](d.erase.md), [d.vect](d.vect.md)*

*[wxGUI](wxGUI.md)*

## AUTHOR

James Westervelt, U.S. Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [d.rast source code](https://github.com/OSGeo/grass/tree/main/display/d.rast)
([history](https://github.com/OSGeo/grass/commits/main/display/d.rast))  
Latest change: Wednesday Feb 12 23:02:46 2025 in commit [9c11460](https://github.com/OSGeo/grass/commit/9c1146064f7c3c21fb0746063fa8bd2cdf4633cb)
