---
name: db.csw.admin.py
description: CSW database manager
keywords: [ csw, metadata ]
---

# db.csw.admin.py

CSW database manager

=== "Command line"

    **db.csw.admin.py**
    [**-rsiohdfa**]
    **configure**=*name*
    [**load_records**=*string*]
    [**export_records**=*string*]
    [**gen_sitemap**=*name*]
    [**url_csw**=*string*]
    [**file_xml**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.csw.admin.py configure=/var/www/html/pycsw/default.cfg
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.csw.admin.py***",
        **configure**=*"/var/www/html/pycsw/default.cfg"*,
        **load_records**=*None*,
        **export_records**=*None*,
        **gen_sitemap**=*None*,
        **url_csw**=*None*,
        **file_xml**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.csw.admin.py", configure="/var/www/html/pycsw/default.cfg")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_csw_admin_py*(**configure**=*"/var/www/html/pycsw/default.cfg"*,
        **load_records**=*None*,
        **export_records**=*None*,
        **gen_sitemap**=*None*,
        **url_csw**=*None*,
        **file_xml**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_csw_admin_py(configure="/var/www/html/pycsw/default.cfg")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **configure**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;path to configure file (default.cfg)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: */var/www/html/pycsw/default.cfg*  
    **load_records**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Load metadata(folder)  
    &nbsp;&nbsp;&nbsp;&nbsp;Loads metadata records from directory into repository  
    **export_records**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Create db dump(folder)  
    &nbsp;&nbsp;&nbsp;&nbsp;Dump metadata records from repository into directory  
    **gen_sitemap**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sitemap  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate XML Sitemap  
    **url_csw**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Url of CSW  
    &nbsp;&nbsp;&nbsp;&nbsp;Execute a CSW request via HTTP POST: URL of CSW  
    **file_xml**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;XML file  
    &nbsp;&nbsp;&nbsp;&nbsp;Execute a CSW request via HTTP POST: XML FILE  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Load records recursively  
    &nbsp;&nbsp;&nbsp;&nbsp;Load records from directory recursively  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Setup database  
    &nbsp;&nbsp;&nbsp;&nbsp;Creates repository tables and indexes  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Database indexes  
    &nbsp;&nbsp;&nbsp;&nbsp;Rebuild repository database indexes  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Optimize db  
    &nbsp;&nbsp;&nbsp;&nbsp;Optimize repository database  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Refresh harvested records  
    &nbsp;&nbsp;&nbsp;&nbsp;Optimize repository database  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Delete all records(!!)  
    &nbsp;&nbsp;&nbsp;&nbsp;Delete all records without prompting  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force confirmation  
    &nbsp;&nbsp;&nbsp;&nbsp;Force confirmation of task  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatic configuration  
    &nbsp;&nbsp;&nbsp;&nbsp;Set database according GRASS default and confugure server  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **configure** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;path to configure file (default.cfg)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: */var/www/html/pycsw/default.cfg*  
    **load_records** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Load metadata(folder)  
    &nbsp;&nbsp;&nbsp;&nbsp;Loads metadata records from directory into repository  
    **export_records** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Create db dump(folder)  
    &nbsp;&nbsp;&nbsp;&nbsp;Dump metadata records from repository into directory  
    **gen_sitemap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sitemap  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate XML Sitemap  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **url_csw** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Url of CSW  
    &nbsp;&nbsp;&nbsp;&nbsp;Execute a CSW request via HTTP POST: URL of CSW  
    **file_xml** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;XML file  
    &nbsp;&nbsp;&nbsp;&nbsp;Execute a CSW request via HTTP POST: XML FILE  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *s*, *i*, *o*, *h*, *d*, *f*, *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Load records recursively  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Load records from directory recursively  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Setup database  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Creates repository tables and indexes  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Database indexes  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Rebuild repository database indexes  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Optimize db  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Optimize repository database  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Refresh harvested records  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Optimize repository database  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Delete all records(!!)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Delete all records without prompting  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force confirmation  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force confirmation of task  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Automatic configuration  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set database according GRASS default and confugure server  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **configure** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;path to configure file (default.cfg)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: */var/www/html/pycsw/default.cfg*  
    **load_records** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Load metadata(folder)  
    &nbsp;&nbsp;&nbsp;&nbsp;Loads metadata records from directory into repository  
    **export_records** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Create db dump(folder)  
    &nbsp;&nbsp;&nbsp;&nbsp;Dump metadata records from repository into directory  
    **gen_sitemap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sitemap  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate XML Sitemap  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **url_csw** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Url of CSW  
    &nbsp;&nbsp;&nbsp;&nbsp;Execute a CSW request via HTTP POST: URL of CSW  
    **file_xml** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;XML file  
    &nbsp;&nbsp;&nbsp;&nbsp;Execute a CSW request via HTTP POST: XML FILE  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *s*, *i*, *o*, *h*, *d*, *f*, *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Load records recursively  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Load records from directory recursively  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Setup database  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Creates repository tables and indexes  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Database indexes  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Rebuild repository database indexes  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Optimize db  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Optimize repository database  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Refresh harvested records  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Optimize repository database  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Delete all records(!!)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Delete all records without prompting  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force confirmation  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force confirmation of task  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Automatic configuration  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set database according GRASS default and confugure server  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module *db.csw.admin* allows to handle csw server.

## NOTES

For dependencies and installation instructions see [wiki
page](https://grasswiki.osgeo.org/wiki/ISO/INSPIRE_Metadata_Support).

## USAGE

For using this module must be installed pycsw libraries. Default path to
configure folder is setup to pycsw install folder(LINUX)
/var/www/html/pycsw in another case, path to config file must by set by
user.

### Configure file

In configure file must be setup few parameters for proper work of pycsw
library.

- server.home  
    Path to folder with installed pycsw
- database.homez  
    Path to database with data of catalog. By default is set to SQLite
    database. E.g GRASS sqlite database.
- server.url  
    For using local serever this parameter should by set to
    <http://localhost:8000/>

```sh
db.csw.harvest source=https://geodati.gov.it/RNDT/csw destination=http://localhost:8000/
```

## SEE ALSO

*[r.info](https://grass.osgeo.org/grass-stable/manuals/r.info.html),
[v.info.iso](v.info.iso.md), [g.gui.metadata](g.gui.metadata.md),
[g.gui.cswbrowser](g.gui.cswbrowser.md),
[db.csw.harvest](db.csw.harvest), [db.csw.run](db.csw.run)*

See also related [wiki
page](https://grasswiki.osgeo.org/wiki/ISO/INSPIRE_Metadata_Support).

## AUTHOR

Matej Krejci, [OSGeoREL](https://geo.fsv.cvut.cz/gwiki/osgeorel) at the
Czech Technical University in Prague, developed during [Google Summer of
Code 2015](https://trac.osgeo.org/grass/wiki/GSoC/2014/MetadataForGRASS)
(mentors: Martin Landa)

## SOURCE CODE

Available at: [db.csw.admin source code](https://github.com/OSGeo/grass-addons/tree/grass8/wxpython/wx.metadata/db.csw.admin)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/wxpython/wx.metadata/db.csw.admin))  
Latest change: Saturday Aug 09 10:30:07 2025 in commit [4b03638](https://github.com/OSGeo/grass-addons/commit/4b036388512a511715f972d46f3245515b15de42)
