---
name: db.databases
description: Lists all databases for a given driver and location.
keywords: [ database, attribute table, SQL ]
---

# db.databases

Lists all databases for a given driver and location.

=== "Command line"

    **db.databases**
    [**driver**=*name*]
    [**location**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.databases
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.databases***",
        **driver**=*"sqlite"*,
        **location**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.databases")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_databases*(**driver**=*"sqlite"*,
        **location**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_databases()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **location**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location  
    &nbsp;&nbsp;&nbsp;&nbsp;Path for SQLite driver, or connection string for PostgreSQL driver  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **location** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location  
    &nbsp;&nbsp;&nbsp;&nbsp;Path for SQLite driver, or connection string for PostgreSQL driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **location** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location  
    &nbsp;&nbsp;&nbsp;&nbsp;Path for SQLite driver, or connection string for PostgreSQL driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.databases* lists all databases for a given **driver** and optionally
**location**.

## NOTES

Currently supported database drivers are *[SQLite](grass-sqlite.md)*,
*[PostgreSQL](grass-pg.md)*, and *[ODBC](grass-odbc.md)*.

Default **location** for SQLite driver is the full path for the current
mapset. For PostgreSQL driver it's empty connection string.

## EXAMPLES

List SQLite databases in the current mapset:

```sh
db.databases driver=sqlite
```

List SQLite databases in a given directory:

```sh
db.databases driver=sqlite location=/opt/sqlite
```

List PostgreSQL databases from database server running on given port:

```sh
db.databases driver=pg location="host=server_name port=5333"
```

## SEE ALSO

*[db.columns](db.columns.md), [db.describe](db.describe.md),
[db.drivers](db.drivers.md), [db.execute](db.execute.md),
[db.login](db.login.md), [db.tables](db.tables.md)*

[GRASS SQL interface](sql.md)

## AUTHORS

Radim Blazek, ITC-Irst, Trento, Italy  
Updated for GRASS 7 by Martin Landa, Czech Technical University in
Prague, Czech Republic

## SOURCE CODE

Available at: [db.databases source code](https://github.com/OSGeo/grass/tree/main/db/db.databases)
([history](https://github.com/OSGeo/grass/commits/main/db/db.databases))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
