---
name: g.access
description: Controls access to the current mapset for other users on the system. If no option given, prints current status.
keywords: [ general, map management, permission ]
---

# g.access

Controls access to the current mapset for other users on the system.

If no option given, prints current status.

=== "Command line"

    **g.access**
    [**group**=*string*]
    [**other**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.access
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.access***",
        **group**=*None*,
        **other**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.access")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_access*(**group**=*None*,
        **other**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_access()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Access for group  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *grant, revoke*  
    **other**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Access for others  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *grant, revoke*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Access for group  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *grant, revoke*  
    **other** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Access for others  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *grant, revoke*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Access for group  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *grant, revoke*  
    **other** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Access for others  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *grant, revoke*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

This program allows the user to control access to the current mapset.
Normally, any user can read data from any GRASS mapset. But sometimes it
is desirable to prohibit access to certain sensitive data. The
*g.access* command allows a user to restrict read and execute access to
the current mapset (see UNIX *chmod* command). *g.access* will not
modify write access to the current mapset.

The user may, for example, allow only users in the same UNIX group to
read data files in the mapset, or restrict the mapset to personal use
only.

## NOTES

Under GRASS, access to the mapset PERMANENT must be open to all users.
This is because GRASS looks for the user's default geographic region
definition settings and the project TITLE in files that are stored under
the PERMANENT mapset directory. The *g.access* command, therefore, will
not allow you to restrict access to the PERMANENT mapset.

The *[g.mapsets](g.mapsets.md)* command isn't smart enough to tell if
access to a specified mapset is restricted, and the user is therefore
allowed to include the names of restricted mapsets in his search path.
However, the data in a restricted mapset is still protected; any
attempts to look for or use data in a restricted mapset will fail. The
user will simply not see any data listed for a restricted mapset.

UNIX filesystem access controls and *g.access* actions are not supported
by MS-Windows.

## SEE ALSO

UNIX manual entries for *chmod(1)* and *group(5)*  
*[g.mapsets](g.mapsets.md)*

## AUTHOR

Michael Shapiro, U.S. Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [g.access source code](https://github.com/OSGeo/grass/tree/main/general/g.access)
([history](https://github.com/OSGeo/grass/commits/main/general/g.access))  
Latest change: Monday Jun 23 19:12:04 2025 in commit [d81912a](https://github.com/OSGeo/grass/commit/d81912adf765c7e86d579395eefe75182f08c185)
