---
name: g.download.location.py
description: Download GRASS Location from the web Get GRASS Location from an URL or file path
keywords: [ general, data, download, import ]
---

# g.download.location.py

Download GRASS Location from the web

Get GRASS Location from an URL or file path

=== "Command line"

    **g.download.location.py**
    **url**=*string*
    [**name**=*name*]
    [**path**=*path*]
    [**dbase**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.download.location.py url=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.download.location.py***",
        **url**,
        **name**=*None*,
        **path**=*None*,
        **dbase**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.download.location.py", url="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_download_location_py*(**url**,
        **name**=*None*,
        **path**=*None*,
        **dbase**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_download_location_py(url="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **url**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of the archive with a location to be downloaded  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of ZIP, TAR.GZ, or other similar archive  
    **name**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    **path**=*path*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS database directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    **dbase**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to database, use path option instead  
    &nbsp;&nbsp;&nbsp;&nbsp;This option is obsolete and replaced by path  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of the archive with a location to be downloaded  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of ZIP, TAR.GZ, or other similar archive  
    **name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS database directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbase, *path*  
    **dbase** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to database, use path option instead  
    &nbsp;&nbsp;&nbsp;&nbsp;This option is obsolete and replaced by path  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of the archive with a location to be downloaded  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of ZIP, TAR.GZ, or other similar archive  
    **name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS database directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbase, *path*  
    **dbase** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to database, use path option instead  
    &nbsp;&nbsp;&nbsp;&nbsp;This option is obsolete and replaced by path  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.download.location* downloads an archived (e.g., `.zip` or `.tar.gz`)
location from a given URL and unpacks it to a specified or current GRASS
GIS Spatial Database. URL can be also a local file on the disk. If the
archive contains a directory which contains a location, the module will
recognize that and use the location automatically. First directory which
is a location is used. Other locations or any other files are ignored.

## SEE ALSO

*[g.mapset](https://grass.osgeo.org/grass-stable/manuals/g.mapset.html),
[g.mapsets](https://grass.osgeo.org/grass-stable/manuals/g.mapsets.html),
[r.proj](https://grass.osgeo.org/grass-stable/manuals/r.proj.html),
[v.proj](https://grass.osgeo.org/grass-stable/manuals/v.proj.html),
[g.proj.all](g.proj.all.md)*

## AUTHOR

Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [g.download.location source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/general/g.download.location)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/general/g.download.location))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
