---
name: g.version
description: Displays GRASS version info. Optionally also prints build or copyright information.
keywords: [ general, support, citing, copyright, version, license ]
---

# g.version

Displays GRASS version info.

Optionally also prints build or copyright information.

=== "Command line"

    **g.version**
    [**-cxbreg**]
    [**format**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.version
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***g.version***",
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("g.version", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_version*(**format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_version(format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **format**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print also the copyright message  
    **-x**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print also the citation options  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print also the build information  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print also the GIS library revision number and date  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print also extended info for additional libraries  
    &nbsp;&nbsp;&nbsp;&nbsp;GDAL/OGR, PROJ, GEOS  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print info in shell script style (including Git reference commit) [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *x*, *b*, *r*, *e*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print also the copyright message  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print also the citation options  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print also the build information  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print also the GIS library revision number and date  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print also extended info for additional libraries  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;GDAL/OGR, PROJ, GEOS  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print info in shell script style (including Git reference commit) [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *x*, *b*, *r*, *e*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print also the copyright message  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print also the citation options  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print also the build information  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print also the GIS library revision number and date  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print also extended info for additional libraries  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;GDAL/OGR, PROJ, GEOS  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print info in shell script style (including Git reference commit) [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.version* prints to standard output the GRASS version number, date,
the GRASS copyright (**-c** flag), and GRASS build information
(**-b** flag).

## NOTES

This program requires no command line arguments; the user simply types
*g.version* on the command line to see the version number and date of
the GRASS software currently being run by the user.

Information about GRASS core [GIS
Library](https://grass.osgeo.org/programming8/gislib.html) can be
printed by **-r** flag.

Version numbers of additional libraries like [PROJ](https://proj.org/),
[GDAL/OGR](https://gdal.org/) or [GEOS](https://trac.osgeo.org/geos) are
printed by **-e** flag.

See also function `version()` from [Python Scripting
Library](https://grasswiki.osgeo.org/wiki/GRASS_Python_Scripting_Library).

```python
import grass.script as gs

print(gs.version())
```

## EXAMPLES

### Basic info

```sh
g.version

GRASS 8.4.0 (2024)
```

### GIS Library info

```sh
g.version -r

GRASS 8.4.0 (2024)
libgis revision: c9e8576cf
libgis date: 2024-04-27T09:38:49+00:00
```

### Full info

<!-- markdownlint-disable MD046 -->
=== "Command line"

    ```sh
    g.version -re format=shell
    ```

    Possible output:

    ```text
    version=8.4.0
    date=2024
    revision=d57f40906
    build_date=2024-05-23
    build_platform=x86_64-pc-linux-gnu
    build_off_t_size=8
    libgis_revision=c9e8576cf
    libgis_date=2024-04-27T09:38:49+00:00
    proj=8.2.1
    gdal=3.4.3
    geos=3.9.2
    sqlite=3.36.0
    ```

=== "Python (grass.script)"

    ```python
    import grass.script as gs

    # Run g.version with JSON output and the -re flags
    data = gs.parse_command(
        "g.version",
        flags="re",
        format="json",
    )

    print(data["version"])
    ```

    Possible output:

    ```text
    8.4.0
    ```

    The whole JSON may look like this:

    ```json
    {
        "version": "8.4.0",
        "date": "2024",
        "revision": "d57f40906",
        "build_date": "2024-05-23",
        "build_platform": "x86_64-pc-linux-gnu",
        "build_off_t_size": 8,
        "libgis_revision": "c9e8576cf",
        "libgis_date": "2024-04-27T09:38:49+00:00",
        "proj": "8.2.1",
        "gdal": "3.4.3",
        "geos": "3.9.2",
        "sqlite": "3.36.0"
    }
    ```
<!-- markdownlint-restore -->

Note: if `revision=exported` is reported instead of the git hash then
the `git` program was not available during compilation of GRASS and
the source code did not contain the `.git/` subdirectory (requires e.g.
to `git clone` the GRASS [software
repository](https://github.com/OSGeo/grass/).)

## Citing GRASS

The GRASS Development Team has invested significant time and effort in
creating GRASS, please cite it when using it for data analysis. The
GRASS [Web site](https://grass.osgeo.org/about/license/) offers
citations in different styles.

## AUTHORS

Michael Shapiro, U.S. Army Construction Engineering Research
Laboratory  
Extended info by Martin Landa, Czech Technical University in Prague,
Czech Republic

## SOURCE CODE

Available at: [g.version source code](https://github.com/OSGeo/grass/tree/main/general/g.version)
([history](https://github.com/OSGeo/grass/commits/main/general/g.version))  
Latest change: Monday Dec 08 21:47:55 2025 in commit [d3c6479](https://github.com/OSGeo/grass/commit/d3c6479bef77a58e3b5d85259303dbfb9c1babe8)
