---
name: i.gcp
description: Manages Ground Control Points (GCPs) non-interactively.
keywords: [ imagery, georectification, GCP ]
---

# i.gcp

Manages Ground Control Points (GCPs) non-interactively.

=== "Command line"

    **i.gcp**
    [**-lcduibrLB**]
    **group**=*name*
    [**image_coordinates**=*east,north*]
    [**target_coordinates**=*east,north*]
    [**status**=*string*]
    [**point**=*integer* [,*integer*,...]]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.gcp group=name image_coordinates=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.gcp***",
        **group**,
        **image_coordinates**=*None*,
        **target_coordinates**=*None*,
        **status**=*"use"*,
        **point**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.gcp", group="name", image_coordinates=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_gcp*(**group**,
        **image_coordinates**=*None*,
        **target_coordinates**=*None*,
        **status**=*"use"*,
        **point**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_gcp(group="name", image_coordinates=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **image_coordinates**=*east,north*  
    &nbsp;&nbsp;&nbsp;&nbsp;Image coordinates to add  
    **target_coordinates**=*east,north*  
    &nbsp;&nbsp;&nbsp;&nbsp;Target coordinates to add  
    **status**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Status for new ground control points  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *use, ignore*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *use*  
    **point**=*integer* [,*integer*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Point number(s) to manage  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;List all ground control points  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Clear all ground control points  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Delete selected ground control points  
    **-u**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use selected ground control points  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore selected ground control points  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Back up the point file  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Restore the backup point file  
    **-L**  
    &nbsp;&nbsp;&nbsp;&nbsp;List all ground control points in the backup point file  
    **-B**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove the backup point file  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **image_coordinates** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Image coordinates to add  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **target_coordinates** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Target coordinates to add  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **status** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Status for new ground control points  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *use, ignore*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *use*  
    **point** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point number(s) to manage  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *c*, *d*, *u*, *i*, *b*, *r*, *L*, *B*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List all ground control points  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Clear all ground control points  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Delete selected ground control points  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use selected ground control points  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore selected ground control points  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Back up the point file  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Restore the backup point file  
    &nbsp;&nbsp;&nbsp;&nbsp;**L**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List all ground control points in the backup point file  
    &nbsp;&nbsp;&nbsp;&nbsp;**B**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove the backup point file  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **image_coordinates** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Image coordinates to add  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **target_coordinates** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Target coordinates to add  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **status** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Status for new ground control points  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *use, ignore*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *use*  
    **point** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point number(s) to manage  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *c*, *d*, *u*, *i*, *b*, *r*, *L*, *B*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List all ground control points  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Clear all ground control points  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Delete selected ground control points  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use selected ground control points  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore selected ground control points  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Back up the point file  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Restore the backup point file  
    &nbsp;&nbsp;&nbsp;&nbsp;**L**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List all ground control points in the backup point file  
    &nbsp;&nbsp;&nbsp;&nbsp;**B**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove the backup point file  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.gcp* manages Ground Control Points (GCPs) non-interactively.

## NOTES

Unlike *g.gui.gcp*, *i.gcp* can be invoked from the command line or
scripts to manage GCPs. It is recommended to create a backup copy of the
original POINTS file using **-b** before making changes to the file. The
backup POINTS file (POINTS\_BAK) can be restored using **-r** or removed
later using **-B**. GCPs in the backup POINTS file can be listed using
**-L**.

## EXAMPLES

List all GCPs in group "sar":

```sh
i.gcp -l group=sar
```

Create a backup copy of the current POINTS file:

```sh
i.gcp -b group=sar
```

Clear all GCPs first by removing the POINTS file:

```sh
i.gcp -c group=sar
```

Add new GCPs at the bottom-left and top-right corners of the satellite
imagery:

```sh
i.gcp group=sar image_coordinates=0,0,31996,32239 target_coordinates=493920,3880490,529470,3916310
```

Add another GCP that will be ignored for now and list all GCPs:

```sh
i.gcp -l group=sar image_coordinates=100,100 target_coordinates=500000,4000000 status=ignore
```

Use the GCP just added and list all:

```sh
i.gcp -u -l group=sar point=3
```

Delete point 1:

```sh
i.gcp -d -l group=sar point=1
```

Ignore points 1-2:

```sh
i.gcp -i -l group=sar point=1-2
```

List GCPs in the backup POINTS file:

```sh
i.gcp -L group=sar
```

Restore the backup POINTS file:

```sh
i.gcp -r group=sar
```

Remove the backup POINTS file:

```sh
i.gcp -B group=sar
```

## SEE ALSO

The GRASS 4 *[Image Processing
manual](https://grass.osgeo.org/gdp/imagery/grass4_image_processing.pdf)*

*[i.group](https://grass.osgeo.org/grass-stable/manuals/i.group.html),
[i.target](https://grass.osgeo.org/grass-stable/manuals/i.target.html),
[i.rectify](https://grass.osgeo.org/grass-stable/manuals/i.rectify.html),
[i.points.auto](i.points.auto.md), [Ground Control Points
Manager](https://grass.osgeo.org/grass-stable/manuals/wxGUI.gcp.html)*

## AUTHOR

[Huidae Cho](mailto:grass4u@gmail-com)

## SOURCE CODE

Available at: [i.gcp source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.gcp)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.gcp))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
